/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posmobile;

import com.adyen.model.posmobile.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantAccount", "setupToken", "store"})
public class CreateSessionRequest {
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_SETUP_TOKEN = "setupToken";
    private String setupToken;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public CreateSessionRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of your merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CreateSessionRequest setupToken(String setupToken) {
        this.setupToken = setupToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The setup token provided by the POS Mobile SDK.  - When using the Android POS Mobile SDK, obtain the token through the `AuthenticationService.authenticate(setupToken)` callback of `AuthenticationService`.  - When using the iOS POS Mobile SDK, obtain the token through the `PaymentServiceDelegate.register(with:)` callback of `PaymentServiceDelegate`.")
    @JsonProperty(value="setupToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSetupToken() {
        return this.setupToken;
    }

    @JsonProperty(value="setupToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSetupToken(String setupToken) {
        this.setupToken = setupToken;
    }

    public CreateSessionRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store that you want to process transactions for.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSessionRequest createSessionRequest = (CreateSessionRequest)o;
        return Objects.equals(this.merchantAccount, createSessionRequest.merchantAccount) && Objects.equals(this.setupToken, createSessionRequest.setupToken) && Objects.equals(this.store, createSessionRequest.store);
    }

    public int hashCode() {
        return Objects.hash(this.merchantAccount, this.setupToken, this.store);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSessionRequest {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    setupToken: ").append(this.toIndentedString(this.setupToken)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateSessionRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CreateSessionRequest)JSON.getMapper().readValue(jsonString, CreateSessionRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

