/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Name2;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountGroups", "active", "email", "name", "roles", "timeZoneCode"})
public class UpdateMerchantUserRequest {
    public static final String JSON_PROPERTY_ACCOUNT_GROUPS = "accountGroups";
    private List<String> accountGroups = null;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_NAME = "name";
    private Name2 name;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = null;
    public static final String JSON_PROPERTY_TIME_ZONE_CODE = "timeZoneCode";
    private String timeZoneCode;

    public UpdateMerchantUserRequest accountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
        return this;
    }

    public UpdateMerchantUserRequest addAccountGroupsItem(String accountGroupsItem) {
        if (this.accountGroups == null) {
            this.accountGroups = new ArrayList<String>();
        }
        this.accountGroups.add(accountGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
    @JsonProperty(value="accountGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAccountGroups() {
        return this.accountGroups;
    }

    @JsonProperty(value="accountGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
    }

    public UpdateMerchantUserRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Sets the status of the user to active (**true**) or inactive (**false**).")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public UpdateMerchantUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the user.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public UpdateMerchantUserRequest name(Name2 name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name2 getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(Name2 name) {
        this.name = name;
    }

    public UpdateMerchantUserRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public UpdateMerchantUserRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public UpdateMerchantUserRequest timeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
        return this;
    }

    @ApiModelProperty(value="The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
    @JsonProperty(value="timeZoneCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZoneCode() {
        return this.timeZoneCode;
    }

    @JsonProperty(value="timeZoneCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMerchantUserRequest updateMerchantUserRequest = (UpdateMerchantUserRequest)o;
        return Objects.equals(this.accountGroups, updateMerchantUserRequest.accountGroups) && Objects.equals(this.active, updateMerchantUserRequest.active) && Objects.equals(this.email, updateMerchantUserRequest.email) && Objects.equals(this.name, updateMerchantUserRequest.name) && Objects.equals(this.roles, updateMerchantUserRequest.roles) && Objects.equals(this.timeZoneCode, updateMerchantUserRequest.timeZoneCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountGroups, this.active, this.email, this.name, this.roles, this.timeZoneCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateMerchantUserRequest {\n");
        sb.append("    accountGroups: ").append(this.toIndentedString(this.accountGroups)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    timeZoneCode: ").append(this.toIndentedString(this.timeZoneCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateMerchantUserRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateMerchantUserRequest)JSON.getMapper().readValue(jsonString, UpdateMerchantUserRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

