/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.balanceplatform.PinChangeRequest;
import com.adyen.model.balanceplatform.PinChangeResponse;
import com.adyen.model.balanceplatform.PublicKeyResponse;
import com.adyen.model.balanceplatform.RestServiceError;
import com.adyen.model.balanceplatform.RevealPinRequest;
import com.adyen.model.balanceplatform.RevealPinResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ManageCardPinApi extends Service {

    public static final String API_VERSION = "2";

    protected String baseURL;

    /**
    * Manage card PIN constructor in {@link com.adyen.service.balanceplatform package}.
    * @param client {@link Client } (required)
    */
    public ManageCardPinApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Manage card PIN constructor in {@link com.adyen.service.balanceplatform package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public ManageCardPinApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Change a card PIN
    *
    * @param pinChangeRequest {@link PinChangeRequest }  (required)
    * @return {@link PinChangeResponse }
    * @throws ApiException if fails to make API call
    */
    public PinChangeResponse changeCardPin(PinChangeRequest pinChangeRequest) throws ApiException, IOException {
        return changeCardPin(pinChangeRequest, null);
    }

    /**
    * Change a card PIN
    *
    * @param pinChangeRequest {@link PinChangeRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PinChangeResponse }
    * @throws ApiException if fails to make API call
    */
    public PinChangeResponse changeCardPin(PinChangeRequest pinChangeRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = pinChangeRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/pins/change", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PinChangeResponse.fromJson(jsonResult);
    }

    /**
    * Get an RSA public key
    *
    * @return {@link PublicKeyResponse }
    * @throws ApiException if fails to make API call
    */
    public PublicKeyResponse publicKey() throws ApiException, IOException {
        return publicKey(null,  null,  null);
    }

    /**
    * Get an RSA public key
    *
    * @param purpose {@link String } Query: The purpose of the public key.  Possible values: **pinChange**, **pinReveal**, **panReveal**.  Default value: **pinReveal**. (optional)
    * @param format {@link String } Query: The encoding format of public key.  Possible values: **jwk**, **pem**.  Default value: **pem**. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PublicKeyResponse }
    * @throws ApiException if fails to make API call
    */
    public PublicKeyResponse publicKey(String purpose, String format, RequestOptions requestOptions) throws ApiException, IOException {
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (purpose != null) {
        queryParams.put("purpose", purpose);
        }
        if (format != null) {
        queryParams.put("format", format);
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/publicKey", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return PublicKeyResponse.fromJson(jsonResult);
    }

    /**
    * Reveal a card PIN
    *
    * @param revealPinRequest {@link RevealPinRequest }  (required)
    * @return {@link RevealPinResponse }
    * @throws ApiException if fails to make API call
    */
    public RevealPinResponse revealCardPin(RevealPinRequest revealPinRequest) throws ApiException, IOException {
        return revealCardPin(revealPinRequest, null);
    }

    /**
    * Reveal a card PIN
    *
    * @param revealPinRequest {@link RevealPinRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link RevealPinResponse }
    * @throws ApiException if fails to make API call
    */
    public RevealPinResponse revealCardPin(RevealPinRequest revealPinRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = revealPinRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/pins/reveal", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return RevealPinResponse.fromJson(jsonResult);
    }
}
