/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpaywebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpaywebhooks.KYCCheckStatusData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * KYCShareholderCheckResult
 */
@JsonPropertyOrder({
  KYCShareholderCheckResult.JSON_PROPERTY_CHECKS,
  KYCShareholderCheckResult.JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE,
  KYCShareholderCheckResult.JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE,
  KYCShareholderCheckResult.JSON_PROPERTY_SHAREHOLDER_CODE
})

public class KYCShareholderCheckResult {
  public static final String JSON_PROPERTY_CHECKS = "checks";
  private List<KYCCheckStatusData> checks = null;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
  private String legalArrangementCode;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE = "legalArrangementEntityCode";
  private String legalArrangementEntityCode;

  public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
  private String shareholderCode;

  public KYCShareholderCheckResult() { 
  }

  public KYCShareholderCheckResult checks(List<KYCCheckStatusData> checks) {
    this.checks = checks;
    return this;
  }

  public KYCShareholderCheckResult addChecksItem(KYCCheckStatusData checksItem) {
    if (this.checks == null) {
      this.checks = new ArrayList<>();
    }
    this.checks.add(checksItem);
    return this;
  }

   /**
   * A list of the checks and their statuses.
   * @return checks
  **/
  @ApiModelProperty(value = "A list of the checks and their statuses.")
  @JsonProperty(JSON_PROPERTY_CHECKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<KYCCheckStatusData> getChecks() {
    return checks;
  }


  @JsonProperty(JSON_PROPERTY_CHECKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChecks(List<KYCCheckStatusData> checks) {
    this.checks = checks;
  }


  public KYCShareholderCheckResult legalArrangementCode(String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
    return this;
  }

   /**
   * The unique ID of the legal arrangement to which the shareholder belongs, if applicable.
   * @return legalArrangementCode
  **/
  @ApiModelProperty(value = "The unique ID of the legal arrangement to which the shareholder belongs, if applicable.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalArrangementCode() {
    return legalArrangementCode;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementCode(String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
  }


  public KYCShareholderCheckResult legalArrangementEntityCode(String legalArrangementEntityCode) {
    this.legalArrangementEntityCode = legalArrangementEntityCode;
    return this;
  }

   /**
   * The unique ID of the legal arrangement entity to which the shareholder belongs, if applicable.
   * @return legalArrangementEntityCode
  **/
  @ApiModelProperty(value = "The unique ID of the legal arrangement entity to which the shareholder belongs, if applicable.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalArrangementEntityCode() {
    return legalArrangementEntityCode;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementEntityCode(String legalArrangementEntityCode) {
    this.legalArrangementEntityCode = legalArrangementEntityCode;
  }


  public KYCShareholderCheckResult shareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
    return this;
  }

   /**
   * The code of the shareholder to which the check applies.
   * @return shareholderCode
  **/
  @ApiModelProperty(value = "The code of the shareholder to which the check applies.")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShareholderCode() {
    return shareholderCode;
  }


  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
  }


  /**
   * Return true if this KYCShareholderCheckResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KYCShareholderCheckResult kyCShareholderCheckResult = (KYCShareholderCheckResult) o;
    return Objects.equals(this.checks, kyCShareholderCheckResult.checks) &&
        Objects.equals(this.legalArrangementCode, kyCShareholderCheckResult.legalArrangementCode) &&
        Objects.equals(this.legalArrangementEntityCode, kyCShareholderCheckResult.legalArrangementEntityCode) &&
        Objects.equals(this.shareholderCode, kyCShareholderCheckResult.shareholderCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checks, legalArrangementCode, legalArrangementEntityCode, shareholderCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KYCShareholderCheckResult {\n");
    sb.append("    checks: ").append(toIndentedString(checks)).append("\n");
    sb.append("    legalArrangementCode: ").append(toIndentedString(legalArrangementCode)).append("\n");
    sb.append("    legalArrangementEntityCode: ").append(toIndentedString(legalArrangementEntityCode)).append("\n");
    sb.append("    shareholderCode: ").append(toIndentedString(shareholderCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of KYCShareholderCheckResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of KYCShareholderCheckResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to KYCShareholderCheckResult
   */
  public static KYCShareholderCheckResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, KYCShareholderCheckResult.class);
  }
/**
  * Convert an instance of KYCShareholderCheckResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

