/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpaywebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * BeneficiarySetupNotificationContent
 */
@JsonPropertyOrder({
  BeneficiarySetupNotificationContent.JSON_PROPERTY_DESTINATION_ACCOUNT_CODE,
  BeneficiarySetupNotificationContent.JSON_PROPERTY_DESTINATION_ACCOUNT_HOLDER_CODE,
  BeneficiarySetupNotificationContent.JSON_PROPERTY_INVALID_FIELDS,
  BeneficiarySetupNotificationContent.JSON_PROPERTY_MERCHANT_REFERENCE,
  BeneficiarySetupNotificationContent.JSON_PROPERTY_SOURCE_ACCOUNT_CODE,
  BeneficiarySetupNotificationContent.JSON_PROPERTY_SOURCE_ACCOUNT_HOLDER_CODE,
  BeneficiarySetupNotificationContent.JSON_PROPERTY_TRANSFER_DATE
})

public class BeneficiarySetupNotificationContent {
  public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
  private String destinationAccountCode;

  public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_HOLDER_CODE = "destinationAccountHolderCode";
  private String destinationAccountHolderCode;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
  private String sourceAccountCode;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_HOLDER_CODE = "sourceAccountHolderCode";
  private String sourceAccountHolderCode;

  public static final String JSON_PROPERTY_TRANSFER_DATE = "transferDate";
  private OffsetDateTime transferDate;

  public BeneficiarySetupNotificationContent() { 
  }

  public BeneficiarySetupNotificationContent destinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
    return this;
  }

   /**
   * The code of the beneficiary account.
   * @return destinationAccountCode
  **/
  @ApiModelProperty(value = "The code of the beneficiary account.")
  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationAccountCode() {
    return destinationAccountCode;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
  }


  public BeneficiarySetupNotificationContent destinationAccountHolderCode(String destinationAccountHolderCode) {
    this.destinationAccountHolderCode = destinationAccountHolderCode;
    return this;
  }

   /**
   * The code of the beneficiary Account Holder.
   * @return destinationAccountHolderCode
  **/
  @ApiModelProperty(value = "The code of the beneficiary Account Holder.")
  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestinationAccountHolderCode() {
    return destinationAccountHolderCode;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAccountHolderCode(String destinationAccountHolderCode) {
    this.destinationAccountHolderCode = destinationAccountHolderCode;
  }


  public BeneficiarySetupNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public BeneficiarySetupNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

   /**
   * A listing of the invalid fields which have caused the Setup Beneficiary request to fail. If this is empty, the Setup Beneficiary request has succeeded.
   * @return invalidFields
  **/
  @ApiModelProperty(value = "A listing of the invalid fields which have caused the Setup Beneficiary request to fail. If this is empty, the Setup Beneficiary request has succeeded.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }


  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }


  public BeneficiarySetupNotificationContent merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

   /**
   * The reference provided by the merchant.
   * @return merchantReference
  **/
  @ApiModelProperty(value = "The reference provided by the merchant.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantReference() {
    return merchantReference;
  }


  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }


  public BeneficiarySetupNotificationContent sourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
    return this;
  }

   /**
   * The code of the benefactor account.
   * @return sourceAccountCode
  **/
  @ApiModelProperty(value = "The code of the benefactor account.")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceAccountCode() {
    return sourceAccountCode;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
  }


  public BeneficiarySetupNotificationContent sourceAccountHolderCode(String sourceAccountHolderCode) {
    this.sourceAccountHolderCode = sourceAccountHolderCode;
    return this;
  }

   /**
   * The code of the benefactor Account Holder.
   * @return sourceAccountHolderCode
  **/
  @ApiModelProperty(value = "The code of the benefactor Account Holder.")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceAccountHolderCode() {
    return sourceAccountHolderCode;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAccountHolderCode(String sourceAccountHolderCode) {
    this.sourceAccountHolderCode = sourceAccountHolderCode;
  }


  public BeneficiarySetupNotificationContent transferDate(OffsetDateTime transferDate) {
    this.transferDate = transferDate;
    return this;
  }

   /**
   * The date on which the beneficiary was set up and funds transferred from benefactor to beneficiary.
   * @return transferDate
  **/
  @ApiModelProperty(value = "The date on which the beneficiary was set up and funds transferred from benefactor to beneficiary.")
  @JsonProperty(JSON_PROPERTY_TRANSFER_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getTransferDate() {
    return transferDate;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFER_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferDate(OffsetDateTime transferDate) {
    this.transferDate = transferDate;
  }


  /**
   * Return true if this BeneficiarySetupNotificationContent object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BeneficiarySetupNotificationContent beneficiarySetupNotificationContent = (BeneficiarySetupNotificationContent) o;
    return Objects.equals(this.destinationAccountCode, beneficiarySetupNotificationContent.destinationAccountCode) &&
        Objects.equals(this.destinationAccountHolderCode, beneficiarySetupNotificationContent.destinationAccountHolderCode) &&
        Objects.equals(this.invalidFields, beneficiarySetupNotificationContent.invalidFields) &&
        Objects.equals(this.merchantReference, beneficiarySetupNotificationContent.merchantReference) &&
        Objects.equals(this.sourceAccountCode, beneficiarySetupNotificationContent.sourceAccountCode) &&
        Objects.equals(this.sourceAccountHolderCode, beneficiarySetupNotificationContent.sourceAccountHolderCode) &&
        Objects.equals(this.transferDate, beneficiarySetupNotificationContent.transferDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(destinationAccountCode, destinationAccountHolderCode, invalidFields, merchantReference, sourceAccountCode, sourceAccountHolderCode, transferDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BeneficiarySetupNotificationContent {\n");
    sb.append("    destinationAccountCode: ").append(toIndentedString(destinationAccountCode)).append("\n");
    sb.append("    destinationAccountHolderCode: ").append(toIndentedString(destinationAccountHolderCode)).append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    sourceAccountCode: ").append(toIndentedString(sourceAccountCode)).append("\n");
    sb.append("    sourceAccountHolderCode: ").append(toIndentedString(sourceAccountHolderCode)).append("\n");
    sb.append("    transferDate: ").append(toIndentedString(transferDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of BeneficiarySetupNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BeneficiarySetupNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to BeneficiarySetupNotificationContent
   */
  public static BeneficiarySetupNotificationContent fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BeneficiarySetupNotificationContent.class);
  }
/**
  * Convert an instance of BeneficiarySetupNotificationContent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

