/*
 * Notification Configuration API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Notification Configuration API provides endpoints for setting up and testing notifications that inform you of events on your platform, for example when a verification check or a payout has been completed.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/notifications). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Notification Configuration API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Notification/v6/createNotificationConfiguration ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayconfiguration;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayconfiguration.NotificationConfigurationDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * UpdateNotificationConfigurationRequest
 */
@JsonPropertyOrder({
  UpdateNotificationConfigurationRequest.JSON_PROPERTY_CONFIGURATION_DETAILS
})

public class UpdateNotificationConfigurationRequest {
  public static final String JSON_PROPERTY_CONFIGURATION_DETAILS = "configurationDetails";
  private NotificationConfigurationDetails configurationDetails;

  public UpdateNotificationConfigurationRequest() { 
  }

  public UpdateNotificationConfigurationRequest configurationDetails(NotificationConfigurationDetails configurationDetails) {
    this.configurationDetails = configurationDetails;
    return this;
  }

   /**
   * Get configurationDetails
   * @return configurationDetails
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONFIGURATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NotificationConfigurationDetails getConfigurationDetails() {
    return configurationDetails;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfigurationDetails(NotificationConfigurationDetails configurationDetails) {
    this.configurationDetails = configurationDetails;
  }


  /**
   * Return true if this UpdateNotificationConfigurationRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest = (UpdateNotificationConfigurationRequest) o;
    return Objects.equals(this.configurationDetails, updateNotificationConfigurationRequest.configurationDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configurationDetails);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateNotificationConfigurationRequest {\n");
    sb.append("    configurationDetails: ").append(toIndentedString(configurationDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of UpdateNotificationConfigurationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UpdateNotificationConfigurationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to UpdateNotificationConfigurationRequest
   */
  public static UpdateNotificationConfigurationRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UpdateNotificationConfigurationRequest.class);
  }
/**
  * Convert an instance of UpdateNotificationConfigurationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

