/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayaccount;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayaccount.MigratedAccounts;
import com.adyen.model.marketpayaccount.MigratedShareholders;
import com.adyen.model.marketpayaccount.MigratedStores;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * MigrationData
 */
@JsonPropertyOrder({
  MigrationData.JSON_PROPERTY_ACCOUNT_HOLDER_ID,
  MigrationData.JSON_PROPERTY_BALANCE_PLATFORM,
  MigrationData.JSON_PROPERTY_MIGRATED,
  MigrationData.JSON_PROPERTY_MIGRATED_ACCOUNTS,
  MigrationData.JSON_PROPERTY_MIGRATED_SHAREHOLDERS,
  MigrationData.JSON_PROPERTY_MIGRATED_STORES,
  MigrationData.JSON_PROPERTY_MIGRATION_DATE
})

public class MigrationData {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
  private String accountHolderId;

  public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
  private String balancePlatform;

  public static final String JSON_PROPERTY_MIGRATED = "migrated";
  private Boolean migrated;

  public static final String JSON_PROPERTY_MIGRATED_ACCOUNTS = "migratedAccounts";
  private List<MigratedAccounts> migratedAccounts = null;

  public static final String JSON_PROPERTY_MIGRATED_SHAREHOLDERS = "migratedShareholders";
  private List<MigratedShareholders> migratedShareholders = null;

  public static final String JSON_PROPERTY_MIGRATED_STORES = "migratedStores";
  private List<MigratedStores> migratedStores = null;

  public static final String JSON_PROPERTY_MIGRATION_DATE = "migrationDate";
  private OffsetDateTime migrationDate;

  public MigrationData() { 
  }

  public MigrationData accountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
    return this;
  }

   /**
   * The unique identifier of the account holder in the balance platform.
   * @return accountHolderId
  **/
  @ApiModelProperty(value = "The unique identifier of the account holder in the balance platform.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountHolderId() {
    return accountHolderId;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
  }


  public MigrationData balancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
    return this;
  }

   /**
   * The unique identifier of the balance platfrom to which the account holder was migrated.
   * @return balancePlatform
  **/
  @ApiModelProperty(value = "The unique identifier of the balance platfrom to which the account holder was migrated.")
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalancePlatform() {
    return balancePlatform;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }


  public MigrationData migrated(Boolean migrated) {
    this.migrated = migrated;
    return this;
  }

   /**
   * Set to **true** if the account holder has been migrated.
   * @return migrated
  **/
  @ApiModelProperty(value = "Set to **true** if the account holder has been migrated.")
  @JsonProperty(JSON_PROPERTY_MIGRATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMigrated() {
    return migrated;
  }


  @JsonProperty(JSON_PROPERTY_MIGRATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMigrated(Boolean migrated) {
    this.migrated = migrated;
  }


  public MigrationData migratedAccounts(List<MigratedAccounts> migratedAccounts) {
    this.migratedAccounts = migratedAccounts;
    return this;
  }

  public MigrationData addMigratedAccountsItem(MigratedAccounts migratedAccountsItem) {
    if (this.migratedAccounts == null) {
      this.migratedAccounts = new ArrayList<>();
    }
    this.migratedAccounts.add(migratedAccountsItem);
    return this;
  }

   /**
   * Contains the mapping of virtual account codes (classic integration) to the balance account codes (balance platform) associated with the migrated account holder.
   * @return migratedAccounts
  **/
  @ApiModelProperty(value = "Contains the mapping of virtual account codes (classic integration) to the balance account codes (balance platform) associated with the migrated account holder.")
  @JsonProperty(JSON_PROPERTY_MIGRATED_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MigratedAccounts> getMigratedAccounts() {
    return migratedAccounts;
  }


  @JsonProperty(JSON_PROPERTY_MIGRATED_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMigratedAccounts(List<MigratedAccounts> migratedAccounts) {
    this.migratedAccounts = migratedAccounts;
  }


  public MigrationData migratedShareholders(List<MigratedShareholders> migratedShareholders) {
    this.migratedShareholders = migratedShareholders;
    return this;
  }

  public MigrationData addMigratedShareholdersItem(MigratedShareholders migratedShareholdersItem) {
    if (this.migratedShareholders == null) {
      this.migratedShareholders = new ArrayList<>();
    }
    this.migratedShareholders.add(migratedShareholdersItem);
    return this;
  }

   /**
   * Contains the mapping of shareholders associated with the migrated legal entities.
   * @return migratedShareholders
  **/
  @ApiModelProperty(value = "Contains the mapping of shareholders associated with the migrated legal entities.")
  @JsonProperty(JSON_PROPERTY_MIGRATED_SHAREHOLDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MigratedShareholders> getMigratedShareholders() {
    return migratedShareholders;
  }


  @JsonProperty(JSON_PROPERTY_MIGRATED_SHAREHOLDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMigratedShareholders(List<MigratedShareholders> migratedShareholders) {
    this.migratedShareholders = migratedShareholders;
  }


  public MigrationData migratedStores(List<MigratedStores> migratedStores) {
    this.migratedStores = migratedStores;
    return this;
  }

  public MigrationData addMigratedStoresItem(MigratedStores migratedStoresItem) {
    if (this.migratedStores == null) {
      this.migratedStores = new ArrayList<>();
    }
    this.migratedStores.add(migratedStoresItem);
    return this;
  }

   /**
   * Contains the mapping of business lines and stores associated with the migrated account holder.
   * @return migratedStores
  **/
  @ApiModelProperty(value = "Contains the mapping of business lines and stores associated with the migrated account holder.")
  @JsonProperty(JSON_PROPERTY_MIGRATED_STORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MigratedStores> getMigratedStores() {
    return migratedStores;
  }


  @JsonProperty(JSON_PROPERTY_MIGRATED_STORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMigratedStores(List<MigratedStores> migratedStores) {
    this.migratedStores = migratedStores;
  }


  public MigrationData migrationDate(OffsetDateTime migrationDate) {
    this.migrationDate = migrationDate;
    return this;
  }

   /**
   * The date when account holder was migrated.
   * @return migrationDate
  **/
  @ApiModelProperty(value = "The date when account holder was migrated.")
  @JsonProperty(JSON_PROPERTY_MIGRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getMigrationDate() {
    return migrationDate;
  }


  @JsonProperty(JSON_PROPERTY_MIGRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMigrationDate(OffsetDateTime migrationDate) {
    this.migrationDate = migrationDate;
  }


  /**
   * Return true if this MigrationData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationData migrationData = (MigrationData) o;
    return Objects.equals(this.accountHolderId, migrationData.accountHolderId) &&
        Objects.equals(this.balancePlatform, migrationData.balancePlatform) &&
        Objects.equals(this.migrated, migrationData.migrated) &&
        Objects.equals(this.migratedAccounts, migrationData.migratedAccounts) &&
        Objects.equals(this.migratedShareholders, migrationData.migratedShareholders) &&
        Objects.equals(this.migratedStores, migrationData.migratedStores) &&
        Objects.equals(this.migrationDate, migrationData.migrationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderId, balancePlatform, migrated, migratedAccounts, migratedShareholders, migratedStores, migrationDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationData {\n");
    sb.append("    accountHolderId: ").append(toIndentedString(accountHolderId)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    migrated: ").append(toIndentedString(migrated)).append("\n");
    sb.append("    migratedAccounts: ").append(toIndentedString(migratedAccounts)).append("\n");
    sb.append("    migratedShareholders: ").append(toIndentedString(migratedShareholders)).append("\n");
    sb.append("    migratedStores: ").append(toIndentedString(migratedStores)).append("\n");
    sb.append("    migrationDate: ").append(toIndentedString(migrationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of MigrationData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of MigrationData
   * @throws JsonProcessingException if the JSON string is invalid with respect to MigrationData
   */
  public static MigrationData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, MigrationData.class);
  }
/**
  * Convert an instance of MigrationData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

