/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.AdditionalCommission;
import com.adyen.model.management.Commission;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * SplitConfigurationLogic
 */
@JsonPropertyOrder({
  SplitConfigurationLogic.JSON_PROPERTY_ACQUIRING_FEES,
  SplitConfigurationLogic.JSON_PROPERTY_ADDITIONAL_COMMISSION,
  SplitConfigurationLogic.JSON_PROPERTY_ADYEN_COMMISSION,
  SplitConfigurationLogic.JSON_PROPERTY_ADYEN_FEES,
  SplitConfigurationLogic.JSON_PROPERTY_ADYEN_MARKUP,
  SplitConfigurationLogic.JSON_PROPERTY_CHARGEBACK,
  SplitConfigurationLogic.JSON_PROPERTY_CHARGEBACK_COST_ALLOCATION,
  SplitConfigurationLogic.JSON_PROPERTY_COMMISSION,
  SplitConfigurationLogic.JSON_PROPERTY_INTERCHANGE,
  SplitConfigurationLogic.JSON_PROPERTY_PAYMENT_FEE,
  SplitConfigurationLogic.JSON_PROPERTY_REFUND,
  SplitConfigurationLogic.JSON_PROPERTY_REFUND_COST_ALLOCATION,
  SplitConfigurationLogic.JSON_PROPERTY_REMAINDER,
  SplitConfigurationLogic.JSON_PROPERTY_SCHEME_FEE,
  SplitConfigurationLogic.JSON_PROPERTY_SPLIT_LOGIC_ID,
  SplitConfigurationLogic.JSON_PROPERTY_SURCHARGE,
  SplitConfigurationLogic.JSON_PROPERTY_TIP
})

public class SplitConfigurationLogic {
  /**
   * Deducts the acquiring fees (the aggregated amount of interchange and scheme fee) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum AcquiringFeesEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    AcquiringFeesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AcquiringFeesEnum fromValue(String value) {
      for (AcquiringFeesEnum b : AcquiringFeesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACQUIRING_FEES = "acquiringFees";
  private AcquiringFeesEnum acquiringFees;

  public static final String JSON_PROPERTY_ADDITIONAL_COMMISSION = "additionalCommission";
  private AdditionalCommission additionalCommission;

  /**
   * Deducts the transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/guides/payments-training-guide/get-the-best-from-your-card-processing) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum AdyenCommissionEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    AdyenCommissionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdyenCommissionEnum fromValue(String value) {
      for (AdyenCommissionEnum b : AdyenCommissionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADYEN_COMMISSION = "adyenCommission";
  private AdyenCommissionEnum adyenCommission;

  /**
   * Deducts the fees due to Adyen (markup or commission) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum AdyenFeesEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    AdyenFeesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdyenFeesEnum fromValue(String value) {
      for (AdyenFeesEnum b : AdyenFeesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADYEN_FEES = "adyenFees";
  private AdyenFeesEnum adyenFees;

  /**
   * Deducts the transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/what-is-interchange) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum AdyenMarkupEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    AdyenMarkupEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdyenMarkupEnum fromValue(String value) {
      for (AdyenMarkupEnum b : AdyenMarkupEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADYEN_MARKUP = "adyenMarkup";
  private AdyenMarkupEnum adyenMarkup;

  /**
   * Specifies how and from which balance account(s) to deduct the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
   */
  public enum ChargebackEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount"),
    
    DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio");

    private String value;

    ChargebackEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChargebackEnum fromValue(String value) {
      for (ChargebackEnum b : ChargebackEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHARGEBACK = "chargeback";
  private ChargebackEnum chargeback;

  /**
   * Deducts the chargeback costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
   */
  public enum ChargebackCostAllocationEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    ChargebackCostAllocationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChargebackCostAllocationEnum fromValue(String value) {
      for (ChargebackCostAllocationEnum b : ChargebackCostAllocationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHARGEBACK_COST_ALLOCATION = "chargebackCostAllocation";
  private ChargebackCostAllocationEnum chargebackCostAllocation;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Commission commission;

  /**
   * Deducts the interchange fee from specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum InterchangeEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    InterchangeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InterchangeEnum fromValue(String value) {
      for (InterchangeEnum b : InterchangeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERCHANGE = "interchange";
  private InterchangeEnum interchange;

  /**
   * Deducts all transaction fees incurred by the payment from the specified balance account. The transaction fees include the acquiring fees (interchange and scheme fee), and the fees due to Adyen (markup or commission). You can book any and all these fees to different balance account by specifying other transaction fee parameters in your split configuration profile:  - [&#x60;adyenCommission&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenCommission): The transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [&#x60;adyenMarkup&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenMarkup): The transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [&#x60;schemeFee&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-schemeFee): The fee paid to the card scheme for using their network. - [&#x60;interchange&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-interchange): The fee paid to the issuer for each payment transaction made with the card network. - [&#x60;adyenFees&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenFees): The aggregated amount of Adyen&#39;s commission and markup. - [&#x60;acquiringFees&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-acquiringFees): The aggregated amount of the interchange and scheme fees.  If you don&#39;t include at least one transaction fee type in the &#x60;splitLogic&#x60; object, Adyen updates the payment request with the &#x60;paymentFee&#x60; parameter, booking all transaction fees to your platform&#39;s liable balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum PaymentFeeEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    PaymentFeeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentFeeEnum fromValue(String value) {
      for (PaymentFeeEnum b : PaymentFeeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_FEE = "paymentFee";
  private PaymentFeeEnum paymentFee;

  /**
   * Specifies how and from which balance account(s) to deduct the refund amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**
   */
  public enum RefundEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount"),
    
    DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio");

    private String value;

    RefundEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundEnum fromValue(String value) {
      for (RefundEnum b : RefundEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUND = "refund";
  private RefundEnum refund;

  /**
   * Deducts the refund costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
   */
  public enum RefundCostAllocationEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    RefundCostAllocationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundCostAllocationEnum fromValue(String value) {
      for (RefundCostAllocationEnum b : RefundCostAllocationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUND_COST_ALLOCATION = "refundCostAllocation";
  private RefundCostAllocationEnum refundCostAllocation;

  /**
   * Books the amount left over after currency conversion to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   */
  public enum RemainderEnum {
    ADDTOLIABLEACCOUNT("addToLiableAccount"),
    
    ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

    private String value;

    RemainderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RemainderEnum fromValue(String value) {
      for (RemainderEnum b : RemainderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REMAINDER = "remainder";
  private RemainderEnum remainder;

  /**
   * Deducts the scheme fee from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum SchemeFeeEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    SchemeFeeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SchemeFeeEnum fromValue(String value) {
      for (SchemeFeeEnum b : SchemeFeeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SCHEME_FEE = "schemeFee";
  private SchemeFeeEnum schemeFee;

  public static final String JSON_PROPERTY_SPLIT_LOGIC_ID = "splitLogicId";
  private String splitLogicId;

  /**
   * Books the surcharge amount to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**
   */
  public enum SurchargeEnum {
    ADDTOLIABLEACCOUNT("addToLiableAccount"),
    
    ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

    private String value;

    SurchargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SurchargeEnum fromValue(String value) {
      for (SurchargeEnum b : SurchargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SURCHARGE = "surcharge";
  private SurchargeEnum surcharge;

  /**
   * Books the tips (gratuity) to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   */
  public enum TipEnum {
    ADDTOLIABLEACCOUNT("addToLiableAccount"),
    
    ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

    private String value;

    TipEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TipEnum fromValue(String value) {
      for (TipEnum b : TipEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TIP = "tip";
  private TipEnum tip;

  public SplitConfigurationLogic() { 
  }

  public SplitConfigurationLogic acquiringFees(AcquiringFeesEnum acquiringFees) {
    this.acquiringFees = acquiringFees;
    return this;
  }

   /**
   * Deducts the acquiring fees (the aggregated amount of interchange and scheme fee) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return acquiringFees
  **/
  @ApiModelProperty(value = "Deducts the acquiring fees (the aggregated amount of interchange and scheme fee) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_ACQUIRING_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AcquiringFeesEnum getAcquiringFees() {
    return acquiringFees;
  }


 /**
  * Deducts the acquiring fees (the aggregated amount of interchange and scheme fee) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
  *
  * @param acquiringFees
  */ 
  @JsonProperty(JSON_PROPERTY_ACQUIRING_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquiringFees(AcquiringFeesEnum acquiringFees) {
    this.acquiringFees = acquiringFees;
  }


  public SplitConfigurationLogic additionalCommission(AdditionalCommission additionalCommission) {
    this.additionalCommission = additionalCommission;
    return this;
  }

   /**
   * Get additionalCommission
   * @return additionalCommission
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdditionalCommission getAdditionalCommission() {
    return additionalCommission;
  }


 /**
  * additionalCommission
  *
  * @param additionalCommission
  */ 
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalCommission(AdditionalCommission additionalCommission) {
    this.additionalCommission = additionalCommission;
  }


  public SplitConfigurationLogic adyenCommission(AdyenCommissionEnum adyenCommission) {
    this.adyenCommission = adyenCommission;
    return this;
  }

   /**
   * Deducts the transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/guides/payments-training-guide/get-the-best-from-your-card-processing) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return adyenCommission
  **/
  @ApiModelProperty(value = "Deducts the transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/guides/payments-training-guide/get-the-best-from-your-card-processing) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_ADYEN_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdyenCommissionEnum getAdyenCommission() {
    return adyenCommission;
  }


 /**
  * Deducts the transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/guides/payments-training-guide/get-the-best-from-your-card-processing) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
  *
  * @param adyenCommission
  */ 
  @JsonProperty(JSON_PROPERTY_ADYEN_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdyenCommission(AdyenCommissionEnum adyenCommission) {
    this.adyenCommission = adyenCommission;
  }


  public SplitConfigurationLogic adyenFees(AdyenFeesEnum adyenFees) {
    this.adyenFees = adyenFees;
    return this;
  }

   /**
   * Deducts the fees due to Adyen (markup or commission) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return adyenFees
  **/
  @ApiModelProperty(value = "Deducts the fees due to Adyen (markup or commission) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_ADYEN_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdyenFeesEnum getAdyenFees() {
    return adyenFees;
  }


 /**
  * Deducts the fees due to Adyen (markup or commission) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
  *
  * @param adyenFees
  */ 
  @JsonProperty(JSON_PROPERTY_ADYEN_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdyenFees(AdyenFeesEnum adyenFees) {
    this.adyenFees = adyenFees;
  }


  public SplitConfigurationLogic adyenMarkup(AdyenMarkupEnum adyenMarkup) {
    this.adyenMarkup = adyenMarkup;
    return this;
  }

   /**
   * Deducts the transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/what-is-interchange) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return adyenMarkup
  **/
  @ApiModelProperty(value = "Deducts the transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/what-is-interchange) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_ADYEN_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdyenMarkupEnum getAdyenMarkup() {
    return adyenMarkup;
  }


 /**
  * Deducts the transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/what-is-interchange) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
  *
  * @param adyenMarkup
  */ 
  @JsonProperty(JSON_PROPERTY_ADYEN_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdyenMarkup(AdyenMarkupEnum adyenMarkup) {
    this.adyenMarkup = adyenMarkup;
  }


  public SplitConfigurationLogic chargeback(ChargebackEnum chargeback) {
    this.chargeback = chargeback;
    return this;
  }

   /**
   * Specifies how and from which balance account(s) to deduct the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
   * @return chargeback
  **/
  @ApiModelProperty(value = "Specifies how and from which balance account(s) to deduct the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.")
  @JsonProperty(JSON_PROPERTY_CHARGEBACK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChargebackEnum getChargeback() {
    return chargeback;
  }


 /**
  * Specifies how and from which balance account(s) to deduct the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
  *
  * @param chargeback
  */ 
  @JsonProperty(JSON_PROPERTY_CHARGEBACK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChargeback(ChargebackEnum chargeback) {
    this.chargeback = chargeback;
  }


  public SplitConfigurationLogic chargebackCostAllocation(ChargebackCostAllocationEnum chargebackCostAllocation) {
    this.chargebackCostAllocation = chargebackCostAllocation;
    return this;
  }

   /**
   * Deducts the chargeback costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
   * @return chargebackCostAllocation
  **/
  @ApiModelProperty(value = "Deducts the chargeback costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**")
  @JsonProperty(JSON_PROPERTY_CHARGEBACK_COST_ALLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChargebackCostAllocationEnum getChargebackCostAllocation() {
    return chargebackCostAllocation;
  }


 /**
  * Deducts the chargeback costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
  *
  * @param chargebackCostAllocation
  */ 
  @JsonProperty(JSON_PROPERTY_CHARGEBACK_COST_ALLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChargebackCostAllocation(ChargebackCostAllocationEnum chargebackCostAllocation) {
    this.chargebackCostAllocation = chargebackCostAllocation;
  }


  public SplitConfigurationLogic commission(Commission commission) {
    this.commission = commission;
    return this;
  }

   /**
   * Get commission
   * @return commission
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Commission getCommission() {
    return commission;
  }


 /**
  * commission
  *
  * @param commission
  */ 
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(Commission commission) {
    this.commission = commission;
  }


  public SplitConfigurationLogic interchange(InterchangeEnum interchange) {
    this.interchange = interchange;
    return this;
  }

   /**
   * Deducts the interchange fee from specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return interchange
  **/
  @ApiModelProperty(value = "Deducts the interchange fee from specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_INTERCHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InterchangeEnum getInterchange() {
    return interchange;
  }


 /**
  * Deducts the interchange fee from specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
  *
  * @param interchange
  */ 
  @JsonProperty(JSON_PROPERTY_INTERCHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterchange(InterchangeEnum interchange) {
    this.interchange = interchange;
  }


  public SplitConfigurationLogic paymentFee(PaymentFeeEnum paymentFee) {
    this.paymentFee = paymentFee;
    return this;
  }

   /**
   * Deducts all transaction fees incurred by the payment from the specified balance account. The transaction fees include the acquiring fees (interchange and scheme fee), and the fees due to Adyen (markup or commission). You can book any and all these fees to different balance account by specifying other transaction fee parameters in your split configuration profile:  - [&#x60;adyenCommission&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenCommission): The transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [&#x60;adyenMarkup&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenMarkup): The transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [&#x60;schemeFee&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-schemeFee): The fee paid to the card scheme for using their network. - [&#x60;interchange&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-interchange): The fee paid to the issuer for each payment transaction made with the card network. - [&#x60;adyenFees&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenFees): The aggregated amount of Adyen&#39;s commission and markup. - [&#x60;acquiringFees&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-acquiringFees): The aggregated amount of the interchange and scheme fees.  If you don&#39;t include at least one transaction fee type in the &#x60;splitLogic&#x60; object, Adyen updates the payment request with the &#x60;paymentFee&#x60; parameter, booking all transaction fees to your platform&#39;s liable balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return paymentFee
  **/
  @ApiModelProperty(value = "Deducts all transaction fees incurred by the payment from the specified balance account. The transaction fees include the acquiring fees (interchange and scheme fee), and the fees due to Adyen (markup or commission). You can book any and all these fees to different balance account by specifying other transaction fee parameters in your split configuration profile:  - [`adyenCommission`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenCommission): The transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [`adyenMarkup`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenMarkup): The transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [`schemeFee`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-schemeFee): The fee paid to the card scheme for using their network. - [`interchange`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-interchange): The fee paid to the issuer for each payment transaction made with the card network. - [`adyenFees`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenFees): The aggregated amount of Adyen's commission and markup. - [`acquiringFees`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-acquiringFees): The aggregated amount of the interchange and scheme fees.  If you don't include at least one transaction fee type in the `splitLogic` object, Adyen updates the payment request with the `paymentFee` parameter, booking all transaction fees to your platform's liable balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentFeeEnum getPaymentFee() {
    return paymentFee;
  }


 /**
  * Deducts all transaction fees incurred by the payment from the specified balance account. The transaction fees include the acquiring fees (interchange and scheme fee), and the fees due to Adyen (markup or commission). You can book any and all these fees to different balance account by specifying other transaction fee parameters in your split configuration profile:  - [&#x60;adyenCommission&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenCommission): The transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [&#x60;adyenMarkup&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenMarkup): The transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [&#x60;schemeFee&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-schemeFee): The fee paid to the card scheme for using their network. - [&#x60;interchange&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-interchange): The fee paid to the issuer for each payment transaction made with the card network. - [&#x60;adyenFees&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenFees): The aggregated amount of Adyen&#39;s commission and markup. - [&#x60;acquiringFees&#x60;](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-acquiringFees): The aggregated amount of the interchange and scheme fees.  If you don&#39;t include at least one transaction fee type in the &#x60;splitLogic&#x60; object, Adyen updates the payment request with the &#x60;paymentFee&#x60; parameter, booking all transaction fees to your platform&#39;s liable balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
  *
  * @param paymentFee
  */ 
  @JsonProperty(JSON_PROPERTY_PAYMENT_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentFee(PaymentFeeEnum paymentFee) {
    this.paymentFee = paymentFee;
  }


  public SplitConfigurationLogic refund(RefundEnum refund) {
    this.refund = refund;
    return this;
  }

   /**
   * Specifies how and from which balance account(s) to deduct the refund amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**
   * @return refund
  **/
  @ApiModelProperty(value = "Specifies how and from which balance account(s) to deduct the refund amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**")
  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundEnum getRefund() {
    return refund;
  }


 /**
  * Specifies how and from which balance account(s) to deduct the refund amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**
  *
  * @param refund
  */ 
  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefund(RefundEnum refund) {
    this.refund = refund;
  }


  public SplitConfigurationLogic refundCostAllocation(RefundCostAllocationEnum refundCostAllocation) {
    this.refundCostAllocation = refundCostAllocation;
    return this;
  }

   /**
   * Deducts the refund costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
   * @return refundCostAllocation
  **/
  @ApiModelProperty(value = "Deducts the refund costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**")
  @JsonProperty(JSON_PROPERTY_REFUND_COST_ALLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundCostAllocationEnum getRefundCostAllocation() {
    return refundCostAllocation;
  }


 /**
  * Deducts the refund costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
  *
  * @param refundCostAllocation
  */ 
  @JsonProperty(JSON_PROPERTY_REFUND_COST_ALLOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundCostAllocation(RefundCostAllocationEnum refundCostAllocation) {
    this.refundCostAllocation = refundCostAllocation;
  }


  public SplitConfigurationLogic remainder(RemainderEnum remainder) {
    this.remainder = remainder;
    return this;
  }

   /**
   * Books the amount left over after currency conversion to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   * @return remainder
  **/
  @ApiModelProperty(value = "Books the amount left over after currency conversion to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_REMAINDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RemainderEnum getRemainder() {
    return remainder;
  }


 /**
  * Books the amount left over after currency conversion to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
  *
  * @param remainder
  */ 
  @JsonProperty(JSON_PROPERTY_REMAINDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemainder(RemainderEnum remainder) {
    this.remainder = remainder;
  }


  public SplitConfigurationLogic schemeFee(SchemeFeeEnum schemeFee) {
    this.schemeFee = schemeFee;
    return this;
  }

   /**
   * Deducts the scheme fee from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return schemeFee
  **/
  @ApiModelProperty(value = "Deducts the scheme fee from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_SCHEME_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SchemeFeeEnum getSchemeFee() {
    return schemeFee;
  }


 /**
  * Deducts the scheme fee from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
  *
  * @param schemeFee
  */ 
  @JsonProperty(JSON_PROPERTY_SCHEME_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSchemeFee(SchemeFeeEnum schemeFee) {
    this.schemeFee = schemeFee;
  }


  public SplitConfigurationLogic splitLogicId(String splitLogicId) {
    this.splitLogicId = splitLogicId;
    return this;
  }

   /**
   * Unique identifier of the collection of split instructions that are applied when the rule conditions are met.
   * @return splitLogicId
  **/
  @ApiModelProperty(value = "Unique identifier of the collection of split instructions that are applied when the rule conditions are met.")
  @JsonProperty(JSON_PROPERTY_SPLIT_LOGIC_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSplitLogicId() {
    return splitLogicId;
  }


 /**
  * Unique identifier of the collection of split instructions that are applied when the rule conditions are met.
  *
  * @param splitLogicId
  */ 
  @JsonProperty(JSON_PROPERTY_SPLIT_LOGIC_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitLogicId(String splitLogicId) {
    this.splitLogicId = splitLogicId;
  }


  public SplitConfigurationLogic surcharge(SurchargeEnum surcharge) {
    this.surcharge = surcharge;
    return this;
  }

   /**
   * Books the surcharge amount to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**
   * @return surcharge
  **/
  @ApiModelProperty(value = "Books the surcharge amount to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**")
  @JsonProperty(JSON_PROPERTY_SURCHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SurchargeEnum getSurcharge() {
    return surcharge;
  }


 /**
  * Books the surcharge amount to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**
  *
  * @param surcharge
  */ 
  @JsonProperty(JSON_PROPERTY_SURCHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSurcharge(SurchargeEnum surcharge) {
    this.surcharge = surcharge;
  }


  public SplitConfigurationLogic tip(TipEnum tip) {
    this.tip = tip;
    return this;
  }

   /**
   * Books the tips (gratuity) to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   * @return tip
  **/
  @ApiModelProperty(value = "Books the tips (gratuity) to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_TIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TipEnum getTip() {
    return tip;
  }


 /**
  * Books the tips (gratuity) to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
  *
  * @param tip
  */ 
  @JsonProperty(JSON_PROPERTY_TIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTip(TipEnum tip) {
    this.tip = tip;
  }


  /**
   * Return true if this SplitConfigurationLogic object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SplitConfigurationLogic splitConfigurationLogic = (SplitConfigurationLogic) o;
    return Objects.equals(this.acquiringFees, splitConfigurationLogic.acquiringFees) &&
        Objects.equals(this.additionalCommission, splitConfigurationLogic.additionalCommission) &&
        Objects.equals(this.adyenCommission, splitConfigurationLogic.adyenCommission) &&
        Objects.equals(this.adyenFees, splitConfigurationLogic.adyenFees) &&
        Objects.equals(this.adyenMarkup, splitConfigurationLogic.adyenMarkup) &&
        Objects.equals(this.chargeback, splitConfigurationLogic.chargeback) &&
        Objects.equals(this.chargebackCostAllocation, splitConfigurationLogic.chargebackCostAllocation) &&
        Objects.equals(this.commission, splitConfigurationLogic.commission) &&
        Objects.equals(this.interchange, splitConfigurationLogic.interchange) &&
        Objects.equals(this.paymentFee, splitConfigurationLogic.paymentFee) &&
        Objects.equals(this.refund, splitConfigurationLogic.refund) &&
        Objects.equals(this.refundCostAllocation, splitConfigurationLogic.refundCostAllocation) &&
        Objects.equals(this.remainder, splitConfigurationLogic.remainder) &&
        Objects.equals(this.schemeFee, splitConfigurationLogic.schemeFee) &&
        Objects.equals(this.splitLogicId, splitConfigurationLogic.splitLogicId) &&
        Objects.equals(this.surcharge, splitConfigurationLogic.surcharge) &&
        Objects.equals(this.tip, splitConfigurationLogic.tip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquiringFees, additionalCommission, adyenCommission, adyenFees, adyenMarkup, chargeback, chargebackCostAllocation, commission, interchange, paymentFee, refund, refundCostAllocation, remainder, schemeFee, splitLogicId, surcharge, tip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SplitConfigurationLogic {\n");
    sb.append("    acquiringFees: ").append(toIndentedString(acquiringFees)).append("\n");
    sb.append("    additionalCommission: ").append(toIndentedString(additionalCommission)).append("\n");
    sb.append("    adyenCommission: ").append(toIndentedString(adyenCommission)).append("\n");
    sb.append("    adyenFees: ").append(toIndentedString(adyenFees)).append("\n");
    sb.append("    adyenMarkup: ").append(toIndentedString(adyenMarkup)).append("\n");
    sb.append("    chargeback: ").append(toIndentedString(chargeback)).append("\n");
    sb.append("    chargebackCostAllocation: ").append(toIndentedString(chargebackCostAllocation)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    interchange: ").append(toIndentedString(interchange)).append("\n");
    sb.append("    paymentFee: ").append(toIndentedString(paymentFee)).append("\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    refundCostAllocation: ").append(toIndentedString(refundCostAllocation)).append("\n");
    sb.append("    remainder: ").append(toIndentedString(remainder)).append("\n");
    sb.append("    schemeFee: ").append(toIndentedString(schemeFee)).append("\n");
    sb.append("    splitLogicId: ").append(toIndentedString(splitLogicId)).append("\n");
    sb.append("    surcharge: ").append(toIndentedString(surcharge)).append("\n");
    sb.append("    tip: ").append(toIndentedString(tip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of SplitConfigurationLogic given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SplitConfigurationLogic
   * @throws JsonProcessingException if the JSON string is invalid with respect to SplitConfigurationLogic
   */
  public static SplitConfigurationLogic fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SplitConfigurationLogic.class);
  }
/**
  * Convert an instance of SplitConfigurationLogic to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

