/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.legalentitymanagement.Attachment;
import com.adyen.model.legalentitymanagement.OwnerEntity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Document
 */
@JsonPropertyOrder({
  Document.JSON_PROPERTY_ATTACHMENT,
  Document.JSON_PROPERTY_ATTACHMENTS,
  Document.JSON_PROPERTY_CREATION_DATE,
  Document.JSON_PROPERTY_DESCRIPTION,
  Document.JSON_PROPERTY_EXPIRY_DATE,
  Document.JSON_PROPERTY_FILE_NAME,
  Document.JSON_PROPERTY_ID,
  Document.JSON_PROPERTY_ISSUER_COUNTRY,
  Document.JSON_PROPERTY_ISSUER_STATE,
  Document.JSON_PROPERTY_MODIFICATION_DATE,
  Document.JSON_PROPERTY_NUMBER,
  Document.JSON_PROPERTY_OWNER,
  Document.JSON_PROPERTY_TYPE
})

public class Document {
  public static final String JSON_PROPERTY_ATTACHMENT = "attachment";
  private Attachment attachment;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  private List<Attachment> attachments = null;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private OffsetDateTime creationDate;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
  @Deprecated
  private String expiryDate;

  public static final String JSON_PROPERTY_FILE_NAME = "fileName";
  private String fileName;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
  @Deprecated
  private String issuerCountry;

  public static final String JSON_PROPERTY_ISSUER_STATE = "issuerState";
  @Deprecated
  private String issuerState;

  public static final String JSON_PROPERTY_MODIFICATION_DATE = "modificationDate";
  private OffsetDateTime modificationDate;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private OwnerEntity owner;

  /**
   * Type of document, used when providing an ID number or uploading a document. The possible values depend on the legal entity type.  * For **organization**, the &#x60;type&#x60; values can be **proofOfAddress**, **registrationDocument**, **vatDocument**, **proofOfOrganizationTaxInfo**, **proofOfOwnership**, **proofOfIndustry**, **proofOfSignatory**, or **proofOfFundingOrWealthSource**.  * For **individual**, the &#x60;type&#x60; values can be **identityCard**, **driversLicense**, **passport**, **liveSelfie**, **proofOfNationalIdNumber**, **proofOfResidency**, **proofOfIndustry**, **proofOfIndividualTaxId**, or **proofOfFundingOrWealthSource**.  * For **soleProprietorship**, the &#x60;type&#x60; values can be **constitutionalDocument**, **proofOfAddress**, or **proofOfIndustry**.  * For **trust**, the &#x60;type&#x60; value can be **constitutionalDocument**.  * Use **bankStatement** to upload documents for a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).
   */
  public enum TypeEnum {
    BANKSTATEMENT("bankStatement"),
    
    DRIVERSLICENSE("driversLicense"),
    
    IDENTITYCARD("identityCard"),
    
    NATIONALIDNUMBER("nationalIdNumber"),
    
    PASSPORT("passport"),
    
    PROOFOFADDRESS("proofOfAddress"),
    
    PROOFOFNATIONALIDNUMBER("proofOfNationalIdNumber"),
    
    PROOFOFRESIDENCY("proofOfResidency"),
    
    REGISTRATIONDOCUMENT("registrationDocument"),
    
    VATDOCUMENT("vatDocument"),
    
    PROOFOFORGANIZATIONTAXINFO("proofOfOrganizationTaxInfo"),
    
    PROOFOFINDIVIDUALTAXID("proofOfIndividualTaxId"),
    
    PROOFOFOWNERSHIP("proofOfOwnership"),
    
    PROOFOFSIGNATORY("proofOfSignatory"),
    
    LIVESELFIE("liveSelfie"),
    
    PROOFOFINDUSTRY("proofOfIndustry"),
    
    CONSTITUTIONALDOCUMENT("constitutionalDocument"),
    
    PROOFOFFUNDINGORWEALTHSOURCE("proofOfFundingOrWealthSource");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public Document() { 
  }

  public Document attachment(Attachment attachment) {
    this.attachment = attachment;
    return this;
  }

   /**
   * Get attachment
   * @return attachment
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Attachment getAttachment() {
    return attachment;
  }


 /**
  * attachment
  *
  * @param attachment
  */ 
  @JsonProperty(JSON_PROPERTY_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachment(Attachment attachment) {
    this.attachment = attachment;
  }


  public Document attachments(List<Attachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  public Document addAttachmentsItem(Attachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

   /**
   * Array that contains the document. The array supports multiple attachments for uploading different sides or pages of a document.
   * @return attachments
  **/
  @ApiModelProperty(value = "Array that contains the document. The array supports multiple attachments for uploading different sides or pages of a document.")
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Attachment> getAttachments() {
    return attachments;
  }


 /**
  * Array that contains the document. The array supports multiple attachments for uploading different sides or pages of a document.
  *
  * @param attachments
  */ 
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(List<Attachment> attachments) {
    this.attachments = attachments;
  }


  public Document creationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
    return this;
  }

   /**
   * The creation date of the document.
   * @return creationDate
  **/
  @ApiModelProperty(value = "The creation date of the document.")
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreationDate() {
    return creationDate;
  }


 /**
  * The creation date of the document.
  *
  * @param creationDate
  */ 
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }


  public Document description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Your description for the document.
   * @return description
  **/
  @ApiModelProperty(required = true, value = "Your description for the document.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


 /**
  * Your description for the document.
  *
  * @param description
  */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  @Deprecated
  public Document expiryDate(String expiryDate) {
    this.expiryDate = expiryDate;
    return this;
  }

   /**
   * The expiry date of the document, in YYYY-MM-DD format.
   * @return expiryDate
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The expiry date of the document, in YYYY-MM-DD format.")
  @JsonProperty(JSON_PROPERTY_EXPIRY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpiryDate() {
    return expiryDate;
  }


 /**
  * The expiry date of the document, in YYYY-MM-DD format.
  *
  * @param expiryDate
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_EXPIRY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryDate(String expiryDate) {
    this.expiryDate = expiryDate;
  }


  public Document fileName(String fileName) {
    this.fileName = fileName;
    return this;
  }

   /**
   * The filename of the document.
   * @return fileName
  **/
  @ApiModelProperty(value = "The filename of the document.")
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileName() {
    return fileName;
  }


 /**
  * The filename of the document.
  *
  * @param fileName
  */ 
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


  public Document id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the document.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier of the document.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


 /**
  * The unique identifier of the document.
  *
  * @param id
  */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  @Deprecated
  public Document issuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
    return this;
  }

   /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the document was issued. For example, **US**.
   * @return issuerCountry
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the document was issued. For example, **US**.")
  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssuerCountry() {
    return issuerCountry;
  }


 /**
  * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the document was issued. For example, **US**.
  *
  * @param issuerCountry
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }


  @Deprecated
  public Document issuerState(String issuerState) {
    this.issuerState = issuerState;
    return this;
  }

   /**
   * The state or province where the document was issued (AU only).
   * @return issuerState
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The state or province where the document was issued (AU only).")
  @JsonProperty(JSON_PROPERTY_ISSUER_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssuerState() {
    return issuerState;
  }


 /**
  * The state or province where the document was issued (AU only).
  *
  * @param issuerState
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_ISSUER_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerState(String issuerState) {
    this.issuerState = issuerState;
  }


  public Document modificationDate(OffsetDateTime modificationDate) {
    this.modificationDate = modificationDate;
    return this;
  }

   /**
   * The modification date of the document.
   * @return modificationDate
  **/
  @ApiModelProperty(value = "The modification date of the document.")
  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getModificationDate() {
    return modificationDate;
  }


 /**
  * The modification date of the document.
  *
  * @param modificationDate
  */ 
  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationDate(OffsetDateTime modificationDate) {
    this.modificationDate = modificationDate;
  }


  public Document number(String number) {
    this.number = number;
    return this;
  }

   /**
   * The number in the document.
   * @return number
  **/
  @ApiModelProperty(value = "The number in the document.")
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNumber() {
    return number;
  }


 /**
  * The number in the document.
  *
  * @param number
  */ 
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }


  public Document owner(OwnerEntity owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OwnerEntity getOwner() {
    return owner;
  }


 /**
  * owner
  *
  * @param owner
  */ 
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(OwnerEntity owner) {
    this.owner = owner;
  }


  public Document type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Type of document, used when providing an ID number or uploading a document. The possible values depend on the legal entity type.  * For **organization**, the &#x60;type&#x60; values can be **proofOfAddress**, **registrationDocument**, **vatDocument**, **proofOfOrganizationTaxInfo**, **proofOfOwnership**, **proofOfIndustry**, **proofOfSignatory**, or **proofOfFundingOrWealthSource**.  * For **individual**, the &#x60;type&#x60; values can be **identityCard**, **driversLicense**, **passport**, **liveSelfie**, **proofOfNationalIdNumber**, **proofOfResidency**, **proofOfIndustry**, **proofOfIndividualTaxId**, or **proofOfFundingOrWealthSource**.  * For **soleProprietorship**, the &#x60;type&#x60; values can be **constitutionalDocument**, **proofOfAddress**, or **proofOfIndustry**.  * For **trust**, the &#x60;type&#x60; value can be **constitutionalDocument**.  * Use **bankStatement** to upload documents for a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).
   * @return type
  **/
  @ApiModelProperty(required = true, value = "Type of document, used when providing an ID number or uploading a document. The possible values depend on the legal entity type.  * For **organization**, the `type` values can be **proofOfAddress**, **registrationDocument**, **vatDocument**, **proofOfOrganizationTaxInfo**, **proofOfOwnership**, **proofOfIndustry**, **proofOfSignatory**, or **proofOfFundingOrWealthSource**.  * For **individual**, the `type` values can be **identityCard**, **driversLicense**, **passport**, **liveSelfie**, **proofOfNationalIdNumber**, **proofOfResidency**, **proofOfIndustry**, **proofOfIndividualTaxId**, or **proofOfFundingOrWealthSource**.  * For **soleProprietorship**, the `type` values can be **constitutionalDocument**, **proofOfAddress**, or **proofOfIndustry**.  * For **trust**, the `type` value can be **constitutionalDocument**.  * Use **bankStatement** to upload documents for a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


 /**
  * Type of document, used when providing an ID number or uploading a document. The possible values depend on the legal entity type.  * For **organization**, the &#x60;type&#x60; values can be **proofOfAddress**, **registrationDocument**, **vatDocument**, **proofOfOrganizationTaxInfo**, **proofOfOwnership**, **proofOfIndustry**, **proofOfSignatory**, or **proofOfFundingOrWealthSource**.  * For **individual**, the &#x60;type&#x60; values can be **identityCard**, **driversLicense**, **passport**, **liveSelfie**, **proofOfNationalIdNumber**, **proofOfResidency**, **proofOfIndustry**, **proofOfIndividualTaxId**, or **proofOfFundingOrWealthSource**.  * For **soleProprietorship**, the &#x60;type&#x60; values can be **constitutionalDocument**, **proofOfAddress**, or **proofOfIndustry**.  * For **trust**, the &#x60;type&#x60; value can be **constitutionalDocument**.  * Use **bankStatement** to upload documents for a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).
  *
  * @param type
  */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  /**
   * Return true if this Document object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Document document = (Document) o;
    return Objects.equals(this.attachment, document.attachment) &&
        Objects.equals(this.attachments, document.attachments) &&
        Objects.equals(this.creationDate, document.creationDate) &&
        Objects.equals(this.description, document.description) &&
        Objects.equals(this.expiryDate, document.expiryDate) &&
        Objects.equals(this.fileName, document.fileName) &&
        Objects.equals(this.id, document.id) &&
        Objects.equals(this.issuerCountry, document.issuerCountry) &&
        Objects.equals(this.issuerState, document.issuerState) &&
        Objects.equals(this.modificationDate, document.modificationDate) &&
        Objects.equals(this.number, document.number) &&
        Objects.equals(this.owner, document.owner) &&
        Objects.equals(this.type, document.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attachment, attachments, creationDate, description, expiryDate, fileName, id, issuerCountry, issuerState, modificationDate, number, owner, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Document {\n");
    sb.append("    attachment: ").append(toIndentedString(attachment)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    expiryDate: ").append(toIndentedString(expiryDate)).append("\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    issuerState: ").append(toIndentedString(issuerState)).append("\n");
    sb.append("    modificationDate: ").append(toIndentedString(modificationDate)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Document given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Document
   * @throws JsonProcessingException if the JSON string is invalid with respect to Document
   */
  public static Document fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Document.class);
  }
/**
  * Convert an instance of Document to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

