/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.balanceplatform.CardOrderItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaginatedGetCardOrderItemResponse
 */
@JsonPropertyOrder({
  PaginatedGetCardOrderItemResponse.JSON_PROPERTY_DATA,
  PaginatedGetCardOrderItemResponse.JSON_PROPERTY_HAS_NEXT,
  PaginatedGetCardOrderItemResponse.JSON_PROPERTY_HAS_PREVIOUS
})

public class PaginatedGetCardOrderItemResponse {
  public static final String JSON_PROPERTY_DATA = "data";
  private List<CardOrderItem> data = new ArrayList<>();

  public static final String JSON_PROPERTY_HAS_NEXT = "hasNext";
  private Boolean hasNext;

  public static final String JSON_PROPERTY_HAS_PREVIOUS = "hasPrevious";
  private Boolean hasPrevious;

  public PaginatedGetCardOrderItemResponse() { 
  }

  public PaginatedGetCardOrderItemResponse data(List<CardOrderItem> data) {
    this.data = data;
    return this;
  }

  public PaginatedGetCardOrderItemResponse addDataItem(CardOrderItem dataItem) {
    this.data.add(dataItem);
    return this;
  }

   /**
   * List of card order items in the card order batch.
   * @return data
  **/
  @ApiModelProperty(required = true, value = "List of card order items in the card order batch.")
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CardOrderItem> getData() {
    return data;
  }


 /**
  * List of card order items in the card order batch.
  *
  * @param data
  */ 
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(List<CardOrderItem> data) {
    this.data = data;
  }


  public PaginatedGetCardOrderItemResponse hasNext(Boolean hasNext) {
    this.hasNext = hasNext;
    return this;
  }

   /**
   * Indicates whether there are more items on the next page.
   * @return hasNext
  **/
  @ApiModelProperty(required = true, value = "Indicates whether there are more items on the next page.")
  @JsonProperty(JSON_PROPERTY_HAS_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasNext() {
    return hasNext;
  }


 /**
  * Indicates whether there are more items on the next page.
  *
  * @param hasNext
  */ 
  @JsonProperty(JSON_PROPERTY_HAS_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasNext(Boolean hasNext) {
    this.hasNext = hasNext;
  }


  public PaginatedGetCardOrderItemResponse hasPrevious(Boolean hasPrevious) {
    this.hasPrevious = hasPrevious;
    return this;
  }

   /**
   * Indicates whether there are more items on the previous page.
   * @return hasPrevious
  **/
  @ApiModelProperty(required = true, value = "Indicates whether there are more items on the previous page.")
  @JsonProperty(JSON_PROPERTY_HAS_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPrevious() {
    return hasPrevious;
  }


 /**
  * Indicates whether there are more items on the previous page.
  *
  * @param hasPrevious
  */ 
  @JsonProperty(JSON_PROPERTY_HAS_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPrevious(Boolean hasPrevious) {
    this.hasPrevious = hasPrevious;
  }


  /**
   * Return true if this PaginatedGetCardOrderItemResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedGetCardOrderItemResponse paginatedGetCardOrderItemResponse = (PaginatedGetCardOrderItemResponse) o;
    return Objects.equals(this.data, paginatedGetCardOrderItemResponse.data) &&
        Objects.equals(this.hasNext, paginatedGetCardOrderItemResponse.hasNext) &&
        Objects.equals(this.hasPrevious, paginatedGetCardOrderItemResponse.hasPrevious);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, hasNext, hasPrevious);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedGetCardOrderItemResponse {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    hasNext: ").append(toIndentedString(hasNext)).append("\n");
    sb.append("    hasPrevious: ").append(toIndentedString(hasPrevious)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaginatedGetCardOrderItemResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaginatedGetCardOrderItemResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaginatedGetCardOrderItemResponse
   */
  public static PaginatedGetCardOrderItemResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaginatedGetCardOrderItemResponse.class);
  }
/**
  * Convert an instance of PaginatedGetCardOrderItemResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

