/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "currencyCode"})
public class MinorUnitsMonetaryValue {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Integer amount;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;

    public MinorUnitsMonetaryValue amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The transaction amount, in [minor units](https://docs.adyen.com/development-resources/currency-codes).")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public MinorUnitsMonetaryValue currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinorUnitsMonetaryValue minorUnitsMonetaryValue = (MinorUnitsMonetaryValue)o;
        return Objects.equals(this.amount, minorUnitsMonetaryValue.amount) && Objects.equals(this.currencyCode, minorUnitsMonetaryValue.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MinorUnitsMonetaryValue {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MinorUnitsMonetaryValue fromJson(String jsonString) throws JsonProcessingException {
        return (MinorUnitsMonetaryValue)JSON.getMapper().readValue(jsonString, MinorUnitsMonetaryValue.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

