/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentMethodGroup;
import com.adyen.model.checkout.PaymentMethodIssuer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"brand", "brands", "configuration", "fundingSource", "group", "inputDetails", "issuers", "name", "type"})
public class PaymentMethod {
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_BRANDS = "brands";
    private List<String> brands = null;
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private Map<String, String> configuration = null;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private FundingSourceEnum fundingSource;
    public static final String JSON_PROPERTY_GROUP = "group";
    private PaymentMethodGroup group;
    public static final String JSON_PROPERTY_INPUT_DETAILS = "inputDetails";
    @Deprecated
    private List<InputDetail> inputDetails = null;
    public static final String JSON_PROPERTY_ISSUERS = "issuers";
    private List<PaymentMethodIssuer> issuers = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public PaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="Brand for the selected gift card. For example: plastix, hmclub.")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public PaymentMethod brands(List<String> brands) {
        this.brands = brands;
        return this;
    }

    public PaymentMethod addBrandsItem(String brandsItem) {
        if (this.brands == null) {
            this.brands = new ArrayList<String>();
        }
        this.brands.add(brandsItem);
        return this;
    }

    @ApiModelProperty(value="List of possible brands. For example: visa, mc.")
    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBrands() {
        return this.brands;
    }

    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrands(List<String> brands) {
        this.brands = brands;
    }

    public PaymentMethod configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public PaymentMethod putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    @ApiModelProperty(value="The configuration of the payment method.")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public PaymentMethod fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source of the payment method.")
    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public PaymentMethod group(PaymentMethodGroup group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentMethodGroup getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroup(PaymentMethodGroup group) {
        this.group = group;
    }

    @Deprecated
    public PaymentMethod inputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        return this;
    }

    public PaymentMethod addInputDetailsItem(InputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<InputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="All input details to be provided to complete the payment with this payment method.")
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InputDetail> getInputDetails() {
        return this.inputDetails;
    }

    @Deprecated
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
    }

    public PaymentMethod issuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
        return this;
    }

    public PaymentMethod addIssuersItem(PaymentMethodIssuer issuersItem) {
        if (this.issuers == null) {
            this.issuers = new ArrayList<PaymentMethodIssuer>();
        }
        this.issuers.add(issuersItem);
        return this;
    }

    @ApiModelProperty(value="A list of issuers for this payment method.")
    @JsonProperty(value="issuers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentMethodIssuer> getIssuers() {
        return this.issuers;
    }

    @JsonProperty(value="issuers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
    }

    public PaymentMethod name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The displayable name of this payment method.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The unique payment method code.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.brand, paymentMethod.brand) && Objects.equals(this.brands, paymentMethod.brands) && Objects.equals(this.configuration, paymentMethod.configuration) && Objects.equals((Object)this.fundingSource, (Object)paymentMethod.fundingSource) && Objects.equals(this.group, paymentMethod.group) && Objects.equals(this.inputDetails, paymentMethod.inputDetails) && Objects.equals(this.issuers, paymentMethod.issuers) && Objects.equals(this.name, paymentMethod.name) && Objects.equals(this.type, paymentMethod.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.brands, this.configuration, this.fundingSource, this.group, this.inputDetails, this.issuers, this.name, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brands: ").append(this.toIndentedString(this.brands)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    inputDetails: ").append(this.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    issuers: ").append(this.toIndentedString(this.issuers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentMethod fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethod)JSON.getMapper().readValue(jsonString, PaymentMethod.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

