/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"paymentData", "paymentMethodType", "type", "url"})
public class CheckoutAwaitAction {
    public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
    private String paymentData;
    public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
    private String paymentMethodType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public CheckoutAwaitAction paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @ApiModelProperty(value="Encoded payment data.")
    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentData() {
        return this.paymentData;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public CheckoutAwaitAction paymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @ApiModelProperty(value="Specifies the payment method.")
    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public CheckoutAwaitAction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**await**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CheckoutAwaitAction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Specifies the URL to redirect to.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutAwaitAction checkoutAwaitAction = (CheckoutAwaitAction)o;
        return Objects.equals(this.paymentData, checkoutAwaitAction.paymentData) && Objects.equals(this.paymentMethodType, checkoutAwaitAction.paymentMethodType) && Objects.equals((Object)this.type, (Object)checkoutAwaitAction.type) && Objects.equals(this.url, checkoutAwaitAction.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentData, this.paymentMethodType, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutAwaitAction {\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString(this.paymentMethodType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CheckoutAwaitAction fromJson(String jsonString) throws JsonProcessingException {
        return (CheckoutAwaitAction)JSON.getMapper().readValue(jsonString, CheckoutAwaitAction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        AWAIT("await");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

