/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "event", "executionDate", "reason"})
public class AccountHolderUpcomingDeadlineNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_EVENT = "event";
    private EventEnum event;
    public static final String JSON_PROPERTY_EXECUTION_DATE = "executionDate";
    private OffsetDateTime executionDate;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    public AccountHolderUpcomingDeadlineNotificationContent accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account holder whom the event refers to.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public AccountHolderUpcomingDeadlineNotificationContent event(EventEnum event) {
        this.event = event;
        return this;
    }

    @ApiModelProperty(value="The event name that will be trigger if no action is taken.")
    @JsonProperty(value="event")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventEnum getEvent() {
        return this.event;
    }

    @JsonProperty(value="event")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvent(EventEnum event) {
        this.event = event;
    }

    public AccountHolderUpcomingDeadlineNotificationContent executionDate(OffsetDateTime executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @ApiModelProperty(value="The execution date scheduled for the event.")
    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExecutionDate() {
        return this.executionDate;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutionDate(OffsetDateTime executionDate) {
        this.executionDate = executionDate;
    }

    public AccountHolderUpcomingDeadlineNotificationContent reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason that leads to scheduling of the event.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderUpcomingDeadlineNotificationContent accountHolderUpcomingDeadlineNotificationContent = (AccountHolderUpcomingDeadlineNotificationContent)o;
        return Objects.equals(this.accountHolderCode, accountHolderUpcomingDeadlineNotificationContent.accountHolderCode) && Objects.equals((Object)this.event, (Object)accountHolderUpcomingDeadlineNotificationContent.event) && Objects.equals(this.executionDate, accountHolderUpcomingDeadlineNotificationContent.executionDate) && Objects.equals(this.reason, accountHolderUpcomingDeadlineNotificationContent.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.event, this.executionDate, this.reason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderUpcomingDeadlineNotificationContent {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    event: ").append(this.toIndentedString((Object)this.event)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderUpcomingDeadlineNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderUpcomingDeadlineNotificationContent)JSON.getMapper().readValue(jsonString, AccountHolderUpcomingDeadlineNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EventEnum {
        ACCESSPII("AccessPii"),
        APITIERUPDATE("ApiTierUpdate"),
        CLOSEACCOUNT("CloseAccount"),
        CLOSESTORES("CloseStores"),
        DELETEBALANCEACCOUNTS("DeleteBalanceAccounts"),
        DELETEBANKACCOUNTS("DeleteBankAccounts"),
        DELETELEGALARRANGEMENTS("DeleteLegalArrangements"),
        DELETELIABLEBANKACCOUNT("DeleteLiableBankAccount"),
        DELETEPAYOUTMETHODS("DeletePayoutMethods"),
        DELETESHAREHOLDERS("DeleteShareholders"),
        DELETESIGNATORIES("DeleteSignatories"),
        INACTIVATEACCOUNT("InactivateAccount"),
        KYCDEADLINEEXTENSION("KYCDeadlineExtension"),
        MIGRATEACCOUNTTOBP("MigrateAccountToBP"),
        RECALCULATEACCOUNTSTATUSANDPROCESSINGTIER("RecalculateAccountStatusAndProcessingTier"),
        REFUNDNOTPAIDOUTTRANSFERS("RefundNotPaidOutTransfers"),
        RESOLVEEVENTS("ResolveEvents"),
        SAVEACCOUNTHOLDER("SaveAccountHolder"),
        SAVEKYCCHECKSTATUS("SaveKYCCheckStatus"),
        SAVEPEPCHECKS("SavePEPChecks"),
        SUSPENDACCOUNT("SuspendAccount"),
        UNSUSPENDACCOUNT("UnSuspendAccount"),
        UPDATEACCOUNTHOLDERSTATE("UpdateAccountHolderState"),
        VERIFICATION("Verification");

        private String value;

        private EventEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventEnum fromValue(String value) {
            for (EventEnum b : EventEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

