/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantAccount", "paymentReference", "pspReference", "reference", "status"})
public class StandalonePaymentCancelResponse {
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PAYMENT_REFERENCE = "paymentReference";
    private String paymentReference;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public StandalonePaymentCancelResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StandalonePaymentCancelResponse paymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The [`reference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_reference) of the payment to cancel.")
    @JsonProperty(value="paymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentReference() {
        return this.paymentReference;
    }

    @JsonProperty(value="paymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    public StandalonePaymentCancelResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="Adyen's 16-character reference associated with the cancel request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public StandalonePaymentCancelResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the cancel request.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public StandalonePaymentCancelResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of your request. This will always have the value **received**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandalonePaymentCancelResponse standalonePaymentCancelResponse = (StandalonePaymentCancelResponse)o;
        return Objects.equals(this.merchantAccount, standalonePaymentCancelResponse.merchantAccount) && Objects.equals(this.paymentReference, standalonePaymentCancelResponse.paymentReference) && Objects.equals(this.pspReference, standalonePaymentCancelResponse.pspReference) && Objects.equals(this.reference, standalonePaymentCancelResponse.reference) && Objects.equals((Object)this.status, (Object)standalonePaymentCancelResponse.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.merchantAccount, this.paymentReference, this.pspReference, this.reference, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandalonePaymentCancelResponse {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    paymentReference: ").append(this.toIndentedString(this.paymentReference)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StandalonePaymentCancelResponse fromJson(String jsonString) throws JsonProcessingException {
        return (StandalonePaymentCancelResponse)JSON.getMapper().readValue(jsonString, StandalonePaymentCancelResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        RECEIVED("received");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

