/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"checkoutAttemptId", "fundingSource", "masterpassTransactionId", "type"})
public class MasterpassDetails {
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private FundingSourceEnum fundingSource;
    public static final String JSON_PROPERTY_MASTERPASS_TRANSACTION_ID = "masterpassTransactionId";
    private String masterpassTransactionId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public MasterpassDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public MasterpassDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public MasterpassDetails masterpassTransactionId(String masterpassTransactionId) {
        this.masterpassTransactionId = masterpassTransactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Masterpass transaction ID.")
    @JsonProperty(value="masterpassTransactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMasterpassTransactionId() {
        return this.masterpassTransactionId;
    }

    @JsonProperty(value="masterpassTransactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMasterpassTransactionId(String masterpassTransactionId) {
        this.masterpassTransactionId = masterpassTransactionId;
    }

    public MasterpassDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="**masterpass**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MasterpassDetails masterpassDetails = (MasterpassDetails)o;
        return Objects.equals(this.checkoutAttemptId, masterpassDetails.checkoutAttemptId) && Objects.equals((Object)this.fundingSource, (Object)masterpassDetails.fundingSource) && Objects.equals(this.masterpassTransactionId, masterpassDetails.masterpassTransactionId) && Objects.equals((Object)this.type, (Object)masterpassDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkoutAttemptId, this.fundingSource, this.masterpassTransactionId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MasterpassDetails {\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    masterpassTransactionId: ").append(this.toIndentedString(this.masterpassTransactionId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MasterpassDetails fromJson(String jsonString) throws JsonProcessingException {
        return (MasterpassDetails)JSON.getMapper().readValue(jsonString, MasterpassDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        MASTERPASS("masterpass");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

