/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Address;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.Phone;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "email", "phone", "webAddress"})
public class ContactDetails {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_PHONE = "phone";
    private Phone phone;
    public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
    private String webAddress;

    public ContactDetails address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public ContactDetails email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address of the account holder.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public ContactDetails phone(Phone phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Phone getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    public ContactDetails webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the account holder's website.")
    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebAddress() {
        return this.webAddress;
    }

    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactDetails contactDetails = (ContactDetails)o;
        return Objects.equals(this.address, contactDetails.address) && Objects.equals(this.email, contactDetails.email) && Objects.equals(this.phone, contactDetails.phone) && Objects.equals(this.webAddress, contactDetails.webAddress);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.email, this.phone, this.webAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactDetails {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ContactDetails fromJson(String jsonString) throws JsonProcessingException {
        return (ContactDetails)JSON.getMapper().readValue(jsonString, ContactDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

