/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.BulkAddress;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"activation", "activationUrl", "bulkAddress", "cardImageId", "carrier", "carrierImageId", "configurationProfileId", "currency", "envelope", "insert", "language", "logoImageId", "pinMailer", "shipmentMethod"})
public class CardConfiguration {
    public static final String JSON_PROPERTY_ACTIVATION = "activation";
    private String activation;
    public static final String JSON_PROPERTY_ACTIVATION_URL = "activationUrl";
    private String activationUrl;
    public static final String JSON_PROPERTY_BULK_ADDRESS = "bulkAddress";
    private BulkAddress bulkAddress;
    public static final String JSON_PROPERTY_CARD_IMAGE_ID = "cardImageId";
    private String cardImageId;
    public static final String JSON_PROPERTY_CARRIER = "carrier";
    private String carrier;
    public static final String JSON_PROPERTY_CARRIER_IMAGE_ID = "carrierImageId";
    private String carrierImageId;
    public static final String JSON_PROPERTY_CONFIGURATION_PROFILE_ID = "configurationProfileId";
    private String configurationProfileId;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_ENVELOPE = "envelope";
    private String envelope;
    public static final String JSON_PROPERTY_INSERT = "insert";
    private String insert;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_LOGO_IMAGE_ID = "logoImageId";
    private String logoImageId;
    public static final String JSON_PROPERTY_PIN_MAILER = "pinMailer";
    private String pinMailer;
    public static final String JSON_PROPERTY_SHIPMENT_METHOD = "shipmentMethod";
    private String shipmentMethod;

    public CardConfiguration activation(String activation) {
        this.activation = activation;
        return this;
    }

    @ApiModelProperty(value="Overrides the activation label design ID defined in the `configurationProfileId`. The activation label is attached to the card and contains the activation instructions.")
    @JsonProperty(value="activation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActivation() {
        return this.activation;
    }

    @JsonProperty(value="activation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivation(String activation) {
        this.activation = activation;
    }

    public CardConfiguration activationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
        return this;
    }

    @ApiModelProperty(value="Your app's URL, if you want to activate cards through your app. For example, **my-app://ref1236a7d**. A QR code is created based on this URL, and is included in the carrier. Before you use this field, reach out to your Adyen contact to set up the QR code process.   Maximum length: 255 characters.")
    @JsonProperty(value="activationUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActivationUrl() {
        return this.activationUrl;
    }

    @JsonProperty(value="activationUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
    }

    public CardConfiguration bulkAddress(BulkAddress bulkAddress) {
        this.bulkAddress = bulkAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bulkAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BulkAddress getBulkAddress() {
        return this.bulkAddress;
    }

    @JsonProperty(value="bulkAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBulkAddress(BulkAddress bulkAddress) {
        this.bulkAddress = bulkAddress;
    }

    public CardConfiguration cardImageId(String cardImageId) {
        this.cardImageId = cardImageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the card image. This is the image that will be printed on the full front of the card.")
    @JsonProperty(value="cardImageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardImageId() {
        return this.cardImageId;
    }

    @JsonProperty(value="cardImageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardImageId(String cardImageId) {
        this.cardImageId = cardImageId;
    }

    public CardConfiguration carrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    @ApiModelProperty(value="Overrides the carrier design ID defined in the `configurationProfileId`. The carrier is the letter or packaging to which the card is attached.")
    @JsonProperty(value="carrier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCarrier() {
        return this.carrier;
    }

    @JsonProperty(value="carrier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public CardConfiguration carrierImageId(String carrierImageId) {
        this.carrierImageId = carrierImageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the carrier image. This is the image that will printed on the letter to which the card is attached.")
    @JsonProperty(value="carrierImageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCarrierImageId() {
        return this.carrierImageId;
    }

    @JsonProperty(value="carrierImageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCarrierImageId(String carrierImageId) {
        this.carrierImageId = carrierImageId;
    }

    public CardConfiguration configurationProfileId(String configurationProfileId) {
        this.configurationProfileId = configurationProfileId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the card configuration profile that contains the settings of the card. For example, the envelope and PIN mailer designs or the logistics company handling the shipment. All the settings in the profile are applied to the card, unless you provide other fields to override them.  For example, send the `shipmentMethod` to override the logistics company defined in the card configuration profile.")
    @JsonProperty(value="configurationProfileId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConfigurationProfileId() {
        return this.configurationProfileId;
    }

    @JsonProperty(value="configurationProfileId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurationProfileId(String configurationProfileId) {
        this.configurationProfileId = configurationProfileId;
    }

    public CardConfiguration currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The three-letter [ISO-4217](https://en.wikipedia.org/wiki/ISO_4217) currency code of the card. For example, **EUR**.")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public CardConfiguration envelope(String envelope) {
        this.envelope = envelope;
        return this;
    }

    @ApiModelProperty(value="Overrides the envelope design ID defined in the `configurationProfileId`. ")
    @JsonProperty(value="envelope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvelope() {
        return this.envelope;
    }

    @JsonProperty(value="envelope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvelope(String envelope) {
        this.envelope = envelope;
    }

    public CardConfiguration insert(String insert) {
        this.insert = insert;
        return this;
    }

    @ApiModelProperty(value="Overrides the insert design ID defined in the `configurationProfileId`. An insert is any additional material, such as marketing materials, that are shipped together with the card.")
    @JsonProperty(value="insert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInsert() {
        return this.insert;
    }

    @JsonProperty(value="insert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInsert(String insert) {
        this.insert = insert;
    }

    public CardConfiguration language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The two-letter [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code of the card. For example, **en**.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public CardConfiguration logoImageId(String logoImageId) {
        this.logoImageId = logoImageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the logo image. This is the image that will be printed on the partial front of the card, such as a logo on the upper right corner.")
    @JsonProperty(value="logoImageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoImageId() {
        return this.logoImageId;
    }

    @JsonProperty(value="logoImageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoImageId(String logoImageId) {
        this.logoImageId = logoImageId;
    }

    public CardConfiguration pinMailer(String pinMailer) {
        this.pinMailer = pinMailer;
        return this;
    }

    @ApiModelProperty(value="Overrides the PIN mailer design ID defined in the `configurationProfileId`. The PIN mailer is the letter on which the PIN is printed.")
    @JsonProperty(value="pinMailer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPinMailer() {
        return this.pinMailer;
    }

    @JsonProperty(value="pinMailer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPinMailer(String pinMailer) {
        this.pinMailer = pinMailer;
    }

    public CardConfiguration shipmentMethod(String shipmentMethod) {
        this.shipmentMethod = shipmentMethod;
        return this;
    }

    @ApiModelProperty(value="Overrides the logistics company defined in the `configurationProfileId`.")
    @JsonProperty(value="shipmentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShipmentMethod() {
        return this.shipmentMethod;
    }

    @JsonProperty(value="shipmentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShipmentMethod(String shipmentMethod) {
        this.shipmentMethod = shipmentMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardConfiguration cardConfiguration = (CardConfiguration)o;
        return Objects.equals(this.activation, cardConfiguration.activation) && Objects.equals(this.activationUrl, cardConfiguration.activationUrl) && Objects.equals(this.bulkAddress, cardConfiguration.bulkAddress) && Objects.equals(this.cardImageId, cardConfiguration.cardImageId) && Objects.equals(this.carrier, cardConfiguration.carrier) && Objects.equals(this.carrierImageId, cardConfiguration.carrierImageId) && Objects.equals(this.configurationProfileId, cardConfiguration.configurationProfileId) && Objects.equals(this.currency, cardConfiguration.currency) && Objects.equals(this.envelope, cardConfiguration.envelope) && Objects.equals(this.insert, cardConfiguration.insert) && Objects.equals(this.language, cardConfiguration.language) && Objects.equals(this.logoImageId, cardConfiguration.logoImageId) && Objects.equals(this.pinMailer, cardConfiguration.pinMailer) && Objects.equals(this.shipmentMethod, cardConfiguration.shipmentMethod);
    }

    public int hashCode() {
        return Objects.hash(this.activation, this.activationUrl, this.bulkAddress, this.cardImageId, this.carrier, this.carrierImageId, this.configurationProfileId, this.currency, this.envelope, this.insert, this.language, this.logoImageId, this.pinMailer, this.shipmentMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardConfiguration {\n");
        sb.append("    activation: ").append(this.toIndentedString(this.activation)).append("\n");
        sb.append("    activationUrl: ").append(this.toIndentedString(this.activationUrl)).append("\n");
        sb.append("    bulkAddress: ").append(this.toIndentedString(this.bulkAddress)).append("\n");
        sb.append("    cardImageId: ").append(this.toIndentedString(this.cardImageId)).append("\n");
        sb.append("    carrier: ").append(this.toIndentedString(this.carrier)).append("\n");
        sb.append("    carrierImageId: ").append(this.toIndentedString(this.carrierImageId)).append("\n");
        sb.append("    configurationProfileId: ").append(this.toIndentedString(this.configurationProfileId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    envelope: ").append(this.toIndentedString(this.envelope)).append("\n");
        sb.append("    insert: ").append(this.toIndentedString(this.insert)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    logoImageId: ").append(this.toIndentedString(this.logoImageId)).append("\n");
        sb.append("    pinMailer: ").append(this.toIndentedString(this.pinMailer)).append("\n");
        sb.append("    shipmentMethod: ").append(this.toIndentedString(this.shipmentMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CardConfiguration fromJson(String jsonString) throws JsonProcessingException {
        return (CardConfiguration)JSON.getMapper().readValue(jsonString, CardConfiguration.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

