/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"bankAccountNumber", "bankCity", "bankLocationId", "bankName", "bic", "countryCode", "iban", "ownerName", "taxId"})
public class BankAccount {
    public static final String JSON_PROPERTY_BANK_ACCOUNT_NUMBER = "bankAccountNumber";
    private String bankAccountNumber;
    public static final String JSON_PROPERTY_BANK_CITY = "bankCity";
    private String bankCity;
    public static final String JSON_PROPERTY_BANK_LOCATION_ID = "bankLocationId";
    private String bankLocationId;
    public static final String JSON_PROPERTY_BANK_NAME = "bankName";
    private String bankName;
    public static final String JSON_PROPERTY_BIC = "bic";
    private String bic;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_TAX_ID = "taxId";
    private String taxId;

    public BankAccount bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="The bank account number (without separators).")
    @JsonProperty(value="bankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    @JsonProperty(value="bankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public BankAccount bankCity(String bankCity) {
        this.bankCity = bankCity;
        return this;
    }

    @ApiModelProperty(value="The bank city.")
    @JsonProperty(value="bankCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankCity() {
        return this.bankCity;
    }

    @JsonProperty(value="bankCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public BankAccount bankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
        return this;
    }

    @ApiModelProperty(value="The location id of the bank. The field value is `nil` in most cases.")
    @JsonProperty(value="bankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankLocationId() {
        return this.bankLocationId;
    }

    @JsonProperty(value="bankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
    }

    public BankAccount bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank.")
    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankName() {
        return this.bankName;
    }

    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BankAccount bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(value="The [Business Identifier Code](https://en.wikipedia.org/wiki/ISO_9362) (BIC) is the SWIFT address assigned to a bank. The field value is `nil` in most cases.")
    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBic() {
        return this.bic;
    }

    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBic(String bic) {
        this.bic = bic;
    }

    public BankAccount countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="Country code where the bank is located.  A valid value is an ISO two-character country code (e.g. 'NL').")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public BankAccount iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="The [International Bank Account Number](https://en.wikipedia.org/wiki/International_Bank_Account_Number) (IBAN).")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIban(String iban) {
        this.iban = iban;
    }

    public BankAccount ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank account holder. If you submit a name with non-Latin characters, we automatically replace some of them with corresponding Latin characters to meet the FATF recommendations. For example: * \u03c712 is converted to ch12. * \u00fcA is converted to euA. * Peter M\u00f8ller is converted to Peter Mller, because banks don't accept '\u00f8'. After replacement, the ownerName must have at least three alphanumeric characters (A-Z, a-z, 0-9), and at least one of them must be a valid Latin character (A-Z, a-z). For example: * John17 - allowed. * J17 - allowed. * 171 - not allowed. * John-7 - allowed. > If provided details don't match the required format, the response returns the error message: 203 'Invalid bank account holder name'.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public BankAccount taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The bank account holder's tax ID.")
    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaxId() {
        return this.taxId;
    }

    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccount bankAccount = (BankAccount)o;
        return Objects.equals(this.bankAccountNumber, bankAccount.bankAccountNumber) && Objects.equals(this.bankCity, bankAccount.bankCity) && Objects.equals(this.bankLocationId, bankAccount.bankLocationId) && Objects.equals(this.bankName, bankAccount.bankName) && Objects.equals(this.bic, bankAccount.bic) && Objects.equals(this.countryCode, bankAccount.countryCode) && Objects.equals(this.iban, bankAccount.iban) && Objects.equals(this.ownerName, bankAccount.ownerName) && Objects.equals(this.taxId, bankAccount.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccountNumber, this.bankCity, this.bankLocationId, this.bankName, this.bic, this.countryCode, this.iban, this.ownerName, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccount {\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    bankCity: ").append(this.toIndentedString(this.bankCity)).append("\n");
        sb.append("    bankLocationId: ").append(this.toIndentedString(this.bankLocationId)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BankAccount fromJson(String jsonString) throws JsonProcessingException {
        return (BankAccount)JSON.getMapper().readValue(jsonString, BankAccount.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

