/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"locale", "redirectUrl", "settings", "themeId"})
public class OnboardingLinkInfo {
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    private String redirectUrl;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private Map<String, Boolean> settings = null;
    public static final String JSON_PROPERTY_THEME_ID = "themeId";
    private String themeId;

    public OnboardingLinkInfo locale(String locale) {
        this.locale = locale;
        return this;
    }

    @ApiModelProperty(value="The language that will be used for the page, specified by a combination of two letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language and [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. See possible valuesfor [marketplaces](https://docs.adyen.com/marketplaces/onboard-users/hosted#supported-languages) or [platforms](https://docs.adyen.com/platforms/onboard-users/hosted#supported-languages).   If not specified in the request or if the language is not supported, the page uses the browser language. If the browser language is not supported, the page uses **en-US** by default.")
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public OnboardingLinkInfo redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @ApiModelProperty(value="The URL where the user is redirected after they complete hosted onboarding.")
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public OnboardingLinkInfo settings(Map<String, Boolean> settings) {
        this.settings = settings;
        return this;
    }

    public OnboardingLinkInfo putSettingsItem(String key, Boolean settingsItem) {
        if (this.settings == null) {
            this.settings = new HashMap<String, Boolean>();
        }
        this.settings.put(key, settingsItem);
        return this;
    }

    @ApiModelProperty(value="Boolean key-value pairs indicating the settings for the hosted onboarding page. The keys are the settings.  Possible keys:  By default, these values are set to **true**. Set to **false** to not allow the action.  - **changeLegalEntityType**: The user can change their legal entity type.  - **editPrefilledCountry**: The user can change the country of their legal entity's address, for example the registered address of an organization.  By default, these values are set to **false**. Set to **true** to allow the action.  - **allowBankAccountFormatSelection**: The user can select the format for their payout account if applicable.  - **allowIntraRegionCrossBorderPayout**: The user can select a payout account in a different EU/EEA country (including Switzerland and the UK) than the country of their legal entity.  By default, these value are set to **false**. Set the following values to **true** to require the user to sign PCI questionnaires based on their sales channels. The user must sign PCI questionnaires for all relevant sales channels.  - **requirePciSignEcommerce**  - **requirePciSignPos**  - **requirePciSignEcomMoto**  - **requirePciSignPosMoto**  ")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Boolean> getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(Map<String, Boolean> settings) {
        this.settings = settings;
    }

    public OnboardingLinkInfo themeId(String themeId) {
        this.themeId = themeId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the hosted onboarding theme.")
    @JsonProperty(value="themeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThemeId() {
        return this.themeId;
    }

    @JsonProperty(value="themeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnboardingLinkInfo onboardingLinkInfo = (OnboardingLinkInfo)o;
        return Objects.equals(this.locale, onboardingLinkInfo.locale) && Objects.equals(this.redirectUrl, onboardingLinkInfo.redirectUrl) && Objects.equals(this.settings, onboardingLinkInfo.settings) && Objects.equals(this.themeId, onboardingLinkInfo.themeId);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.redirectUrl, this.settings, this.themeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OnboardingLinkInfo {\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    themeId: ").append(this.toIndentedString(this.themeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static OnboardingLinkInfo fromJson(String jsonString) throws JsonProcessingException {
        return (OnboardingLinkInfo)JSON.getMapper().readValue(jsonString, OnboardingLinkInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

