/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"bankAccountNumber", "bankAccountType", "bankLocationId", "checkoutAttemptId", "encryptedBankAccountNumber", "encryptedBankLocationId", "ownerName", "recurringDetailReference", "storedPaymentMethodId", "type"})
public class AchDetails {
    public static final String JSON_PROPERTY_BANK_ACCOUNT_NUMBER = "bankAccountNumber";
    private String bankAccountNumber;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_TYPE = "bankAccountType";
    private BankAccountTypeEnum bankAccountType;
    public static final String JSON_PROPERTY_BANK_LOCATION_ID = "bankLocationId";
    private String bankLocationId;
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_ENCRYPTED_BANK_ACCOUNT_NUMBER = "encryptedBankAccountNumber";
    private String encryptedBankAccountNumber;
    public static final String JSON_PROPERTY_ENCRYPTED_BANK_LOCATION_ID = "encryptedBankLocationId";
    private String encryptedBankLocationId;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @Deprecated
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public AchDetails bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="The bank account number (without separators).")
    @JsonProperty(value="bankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    @JsonProperty(value="bankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public AchDetails bankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
        return this;
    }

    @ApiModelProperty(value="The bank account type (checking, savings...).")
    @JsonProperty(value="bankAccountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccountTypeEnum getBankAccountType() {
        return this.bankAccountType;
    }

    @JsonProperty(value="bankAccountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
    }

    public AchDetails bankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
        return this;
    }

    @ApiModelProperty(value="The bank routing number of the account. The field value is `nil` in most cases.")
    @JsonProperty(value="bankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankLocationId() {
        return this.bankLocationId;
    }

    @JsonProperty(value="bankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
    }

    public AchDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public AchDetails encryptedBankAccountNumber(String encryptedBankAccountNumber) {
        this.encryptedBankAccountNumber = encryptedBankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="Encrypted bank account number. The bank account number (without separators).")
    @JsonProperty(value="encryptedBankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedBankAccountNumber() {
        return this.encryptedBankAccountNumber;
    }

    @JsonProperty(value="encryptedBankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedBankAccountNumber(String encryptedBankAccountNumber) {
        this.encryptedBankAccountNumber = encryptedBankAccountNumber;
    }

    public AchDetails encryptedBankLocationId(String encryptedBankLocationId) {
        this.encryptedBankLocationId = encryptedBankLocationId;
        return this;
    }

    @ApiModelProperty(value="Encrypted location id. The bank routing number of the account. The field value is `nil` in most cases.")
    @JsonProperty(value="encryptedBankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedBankLocationId() {
        return this.encryptedBankLocationId;
    }

    @JsonProperty(value="encryptedBankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedBankLocationId(String encryptedBankLocationId) {
        this.encryptedBankLocationId = encryptedBankLocationId;
    }

    public AchDetails ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank account holder. If you submit a name with non-Latin characters, we automatically replace some of them with corresponding Latin characters to meet the FATF recommendations. For example: * \u03c712 is converted to ch12. * \u00fcA is converted to euA. * Peter M\u00f8ller is converted to Peter Mller, because banks don't accept '\u00f8'. After replacement, the ownerName must have at least three alphanumeric characters (A-Z, a-z, 0-9), and at least one of them must be a valid Latin character (A-Z, a-z). For example: * John17 - allowed. * J17 - allowed. * 171 - not allowed. * John-7 - allowed. > If provided details don't match the required format, the response returns the error message: 203 'Invalid bank account holder name'.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Deprecated
    public AchDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @Deprecated
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public AchDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public AchDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="**ach**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AchDetails achDetails = (AchDetails)o;
        return Objects.equals(this.bankAccountNumber, achDetails.bankAccountNumber) && Objects.equals((Object)this.bankAccountType, (Object)achDetails.bankAccountType) && Objects.equals(this.bankLocationId, achDetails.bankLocationId) && Objects.equals(this.checkoutAttemptId, achDetails.checkoutAttemptId) && Objects.equals(this.encryptedBankAccountNumber, achDetails.encryptedBankAccountNumber) && Objects.equals(this.encryptedBankLocationId, achDetails.encryptedBankLocationId) && Objects.equals(this.ownerName, achDetails.ownerName) && Objects.equals(this.recurringDetailReference, achDetails.recurringDetailReference) && Objects.equals(this.storedPaymentMethodId, achDetails.storedPaymentMethodId) && Objects.equals((Object)this.type, (Object)achDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankAccountNumber, this.bankAccountType, this.bankLocationId, this.checkoutAttemptId, this.encryptedBankAccountNumber, this.encryptedBankLocationId, this.ownerName, this.recurringDetailReference, this.storedPaymentMethodId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AchDetails {\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    bankAccountType: ").append(this.toIndentedString((Object)this.bankAccountType)).append("\n");
        sb.append("    bankLocationId: ").append(this.toIndentedString(this.bankLocationId)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    encryptedBankAccountNumber: ").append(this.toIndentedString(this.encryptedBankAccountNumber)).append("\n");
        sb.append("    encryptedBankLocationId: ").append(this.toIndentedString(this.encryptedBankLocationId)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AchDetails fromJson(String jsonString) throws JsonProcessingException {
        return (AchDetails)JSON.getMapper().readValue(jsonString, AchDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ACH("ach"),
        ACH_PLAID("ach_plaid");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum BankAccountTypeEnum {
        BALANCE("balance"),
        CHECKING("checking"),
        DEPOSIT("deposit"),
        GENERAL("general"),
        OTHER("other"),
        PAYMENT("payment"),
        SAVINGS("savings");

        private String value;

        private BankAccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BankAccountTypeEnum fromValue(String value) {
            for (BankAccountTypeEnum b : BankAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

