/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountNumber", "bankCode", "formFactor", "type"})
public class CZLocalAccountIdentification {
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_BANK_CODE = "bankCode";
    private String bankCode;
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private String formFactor = "physical";
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.CZLOCAL;

    public CZLocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 2- to 16-digit bank account number (\u010c\u00edslo \u00fa\u010dtu) in the following format:  - The optional prefix (p\u0159ed\u010d\u00edsl\u00ed).  - The required second part (z\u00e1kladn\u00ed \u010d\u00e1st) which must be at least two non-zero digits.  Examples:  - **19-123457** (with prefix)  - **123457** (without prefix)  - **000019-0000123457** (with prefix, normalized)  - **000000-0000123457** (without prefix, normalized)")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CZLocalAccountIdentification bankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The 4-digit bank code (K\u00f3d banky), without separators or whitespace.")
    @JsonProperty(value="bankCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankCode() {
        return this.bankCode;
    }

    @JsonProperty(value="bankCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public CZLocalAccountIdentification formFactor(String formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(value="The form factor of the account.  Possible values: **physical**, **virtual**. Default value: **physical**.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(String formFactor) {
        this.formFactor = formFactor;
    }

    public CZLocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**czLocal**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CZLocalAccountIdentification czLocalAccountIdentification = (CZLocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, czLocalAccountIdentification.accountNumber) && Objects.equals(this.bankCode, czLocalAccountIdentification.bankCode) && Objects.equals(this.formFactor, czLocalAccountIdentification.formFactor) && Objects.equals((Object)this.type, (Object)czLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.bankCode, this.formFactor, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CZLocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    bankCode: ").append(this.toIndentedString(this.bankCode)).append("\n");
        sb.append("    formFactor: ").append(this.toIndentedString(this.formFactor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CZLocalAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (CZLocalAccountIdentification)JSON.getMapper().readValue(jsonString, CZLocalAccountIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        CZLOCAL("czLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

