/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.FraudCheckResultWrapper;
import com.adyen.model.payout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountScore", "results"})
public class FraudResult {
    public static final String JSON_PROPERTY_ACCOUNT_SCORE = "accountScore";
    private Integer accountScore;
    public static final String JSON_PROPERTY_RESULTS = "results";
    private List<FraudCheckResultWrapper> results = null;

    public FraudResult accountScore(Integer accountScore) {
        this.accountScore = accountScore;
        return this;
    }

    @ApiModelProperty(required=true, value="The total fraud score generated by the risk checks.")
    @JsonProperty(value="accountScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAccountScore() {
        return this.accountScore;
    }

    @JsonProperty(value="accountScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountScore(Integer accountScore) {
        this.accountScore = accountScore;
    }

    public FraudResult results(List<FraudCheckResultWrapper> results) {
        this.results = results;
        return this;
    }

    public FraudResult addResultsItem(FraudCheckResultWrapper resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<FraudCheckResultWrapper>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @ApiModelProperty(value="The result of the individual risk checks.")
    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FraudCheckResultWrapper> getResults() {
        return this.results;
    }

    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResults(List<FraudCheckResultWrapper> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FraudResult fraudResult = (FraudResult)o;
        return Objects.equals(this.accountScore, fraudResult.accountScore) && Objects.equals(this.results, fraudResult.results);
    }

    public int hashCode() {
        return Objects.hash(this.accountScore, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FraudResult {\n");
        sb.append("    accountScore: ").append(this.toIndentedString(this.accountScore)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FraudResult fromJson(String jsonString) throws JsonProcessingException {
        return (FraudResult)JSON.getMapper().readValue(jsonString, FraudResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

