/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountNumber", "bsbCode", "formFactor", "type"})
public class AULocalAccountIdentification {
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_BSB_CODE = "bsbCode";
    private String bsbCode;
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private String formFactor = "physical";
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.AULOCAL;

    public AULocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank account number, without separators or whitespace.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public AULocalAccountIdentification bsbCode(String bsbCode) {
        this.bsbCode = bsbCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The 6-digit [Bank State Branch (BSB) code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or whitespace.")
    @JsonProperty(value="bsbCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBsbCode() {
        return this.bsbCode;
    }

    @JsonProperty(value="bsbCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBsbCode(String bsbCode) {
        this.bsbCode = bsbCode;
    }

    public AULocalAccountIdentification formFactor(String formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(value="Business accounts with a `formFactor` value of **physical** are business accounts issued under the central bank of that country. The default value is **physical** for NL, US, and UK business accounts.   Adyen creates a local IBAN for business accounts when the `formFactor`\u00e5 value is set to **virtual**. The local IBANs that are supported are for DE and FR, which reference a physical NL account, with funds being routed through the central bank of NL.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(String formFactor) {
        this.formFactor = formFactor;
    }

    public AULocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**auLocal**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AULocalAccountIdentification auLocalAccountIdentification = (AULocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, auLocalAccountIdentification.accountNumber) && Objects.equals(this.bsbCode, auLocalAccountIdentification.bsbCode) && Objects.equals(this.formFactor, auLocalAccountIdentification.formFactor) && Objects.equals((Object)this.type, (Object)auLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.bsbCode, this.formFactor, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AULocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    bsbCode: ").append(this.toIndentedString(this.bsbCode)).append("\n");
        sb.append("    formFactor: ").append(this.toIndentedString(this.formFactor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AULocalAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (AULocalAccountIdentification)JSON.getMapper().readValue(jsonString, AULocalAccountIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        AULOCAL("auLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

