/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.legalentitymanagement.Document;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class DocumentsApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public DocumentsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    public DocumentsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void deleteDocument(String id) throws ApiException, IOException {
        this.deleteDocument(id, null);
    }

    public void deleteDocument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/documents/{id}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public Document getDocument(String id) throws ApiException, IOException {
        return this.getDocument(id, null);
    }

    public Document getDocument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/documents/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Document.fromJson(jsonResult);
    }

    public Document updateDocument(String id, Document document) throws ApiException, IOException {
        return this.updateDocument(id, document, null);
    }

    public Document updateDocument(String id, Document document, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = document.toJson();
        Resource resource = new Resource(this, this.baseURL + "/documents/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Document.fromJson(jsonResult);
    }

    public Document uploadDocumentForVerificationChecks(Document document) throws ApiException, IOException {
        return this.uploadDocumentForVerificationChecks(document, null);
    }

    public Document uploadDocumentForVerificationChecks(Document document, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = document.toJson();
        Resource resource = new Resource(this, this.baseURL + "/documents", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return Document.fromJson(jsonResult);
    }
}

