/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"language", "type"})
public class GetTermsOfServiceDocumentRequest {
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public GetTermsOfServiceDocumentRequest language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(required=true, value="The language to be used for the Terms of Service document, specified by the two-letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code. Possible value: **en** for English.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public GetTermsOfServiceDocumentRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of Terms of Service.  Possible values: *  **adyenForPlatformsManage** *  **adyenIssuing** *  **adyenForPlatformsAdvanced** *  **adyenCapital** *  **adyenAccount** *  **adyenCard** *  **adyenFranchisee**  ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTermsOfServiceDocumentRequest getTermsOfServiceDocumentRequest = (GetTermsOfServiceDocumentRequest)o;
        return Objects.equals(this.language, getTermsOfServiceDocumentRequest.language) && Objects.equals((Object)this.type, (Object)getTermsOfServiceDocumentRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTermsOfServiceDocumentRequest {\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetTermsOfServiceDocumentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GetTermsOfServiceDocumentRequest)JSON.getMapper().readValue(jsonString, GetTermsOfServiceDocumentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ADYENACCOUNT("adyenAccount"),
        ADYENCAPITAL("adyenCapital"),
        ADYENCARD("adyenCard"),
        ADYENFORPLATFORMSADVANCED("adyenForPlatformsAdvanced"),
        ADYENFORPLATFORMSMANAGE("adyenForPlatformsManage"),
        ADYENFRANCHISEE("adyenFranchisee"),
        ADYENISSUING("adyenIssuing");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

