/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acceptedBy", "id", "ipAddress", "language", "termsOfServiceDocumentId", "type"})
public class AcceptTermsOfServiceResponse {
    public static final String JSON_PROPERTY_ACCEPTED_BY = "acceptedBy";
    private String acceptedBy;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_ID = "termsOfServiceDocumentId";
    private String termsOfServiceDocumentId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public AcceptTermsOfServiceResponse acceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the user that accepted the Terms of Service.")
    @JsonProperty(value="acceptedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcceptedBy() {
        return this.acceptedBy;
    }

    @JsonProperty(value="acceptedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
    }

    public AcceptTermsOfServiceResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the Terms of Service acceptance.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AcceptTermsOfServiceResponse ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(value="The IP address of the user that accepted the Terms of Service.")
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public AcceptTermsOfServiceResponse language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The language used for the Terms of Service document, specified by the two-letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code. Possible value: **en** for English.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public AcceptTermsOfServiceResponse termsOfServiceDocumentId(String termsOfServiceDocumentId) {
        this.termsOfServiceDocumentId = termsOfServiceDocumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the Terms of Service document.")
    @JsonProperty(value="termsOfServiceDocumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTermsOfServiceDocumentId() {
        return this.termsOfServiceDocumentId;
    }

    @JsonProperty(value="termsOfServiceDocumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTermsOfServiceDocumentId(String termsOfServiceDocumentId) {
        this.termsOfServiceDocumentId = termsOfServiceDocumentId;
    }

    public AcceptTermsOfServiceResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of Terms of Service.  Possible values: *  **adyenForPlatformsManage** *  **adyenIssuing** *  **adyenForPlatformsAdvanced** *  **adyenCapital** *  **adyenAccount** *  **adyenCard** *  **adyenFranchisee**  ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptTermsOfServiceResponse acceptTermsOfServiceResponse = (AcceptTermsOfServiceResponse)o;
        return Objects.equals(this.acceptedBy, acceptTermsOfServiceResponse.acceptedBy) && Objects.equals(this.id, acceptTermsOfServiceResponse.id) && Objects.equals(this.ipAddress, acceptTermsOfServiceResponse.ipAddress) && Objects.equals(this.language, acceptTermsOfServiceResponse.language) && Objects.equals(this.termsOfServiceDocumentId, acceptTermsOfServiceResponse.termsOfServiceDocumentId) && Objects.equals((Object)this.type, (Object)acceptTermsOfServiceResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptedBy, this.id, this.ipAddress, this.language, this.termsOfServiceDocumentId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceptTermsOfServiceResponse {\n");
        sb.append("    acceptedBy: ").append(this.toIndentedString(this.acceptedBy)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    termsOfServiceDocumentId: ").append(this.toIndentedString(this.termsOfServiceDocumentId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AcceptTermsOfServiceResponse fromJson(String jsonString) throws JsonProcessingException {
        return (AcceptTermsOfServiceResponse)JSON.getMapper().readValue(jsonString, AcceptTermsOfServiceResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ADYENACCOUNT("adyenAccount"),
        ADYENCAPITAL("adyenCapital"),
        ADYENCARD("adyenCard"),
        ADYENFORPLATFORMSADVANCED("adyenForPlatformsAdvanced"),
        ADYENFORPLATFORMSMANAGE("adyenForPlatformsManage"),
        ADYENFRANCHISEE("adyenFranchisee"),
        ADYENISSUING("adyenIssuing");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

