/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;

@JsonPropertyOrder(value={"content", "contentType"})
public class GetTaxFormResponse {
    public static final String JSON_PROPERTY_CONTENT = "content";
    private byte[] content;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private ContentTypeEnum contentType;

    public GetTaxFormResponse content(byte[] content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(required=true, value="The content of the tax form in Base64 format.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(byte[] content) {
        this.content = content;
    }

    public GetTaxFormResponse contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(value="The content type of the tax form.  Possible values: *  **application/pdf**  ")
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTaxFormResponse getTaxFormResponse = (GetTaxFormResponse)o;
        return Arrays.equals(this.content, getTaxFormResponse.content) && Objects.equals((Object)this.contentType, (Object)getTaxFormResponse.contentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.content), this.contentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTaxFormResponse {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetTaxFormResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GetTaxFormResponse)JSON.getMapper().readValue(jsonString, GetTaxFormResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ContentTypeEnum {
        APPLICATION_PDF("application/pdf");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentTypeEnum fromValue(String value) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

