/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"cavv", "cavvAlgorithm", "eci", "threeDAuthenticatedResponse", "threeDOfferedResponse", "xid"})
public class ThreeDS1Result {
    public static final String JSON_PROPERTY_CAVV = "cavv";
    private String cavv;
    public static final String JSON_PROPERTY_CAVV_ALGORITHM = "cavvAlgorithm";
    private String cavvAlgorithm;
    public static final String JSON_PROPERTY_ECI = "eci";
    private String eci;
    public static final String JSON_PROPERTY_THREE_D_AUTHENTICATED_RESPONSE = "threeDAuthenticatedResponse";
    private String threeDAuthenticatedResponse;
    public static final String JSON_PROPERTY_THREE_D_OFFERED_RESPONSE = "threeDOfferedResponse";
    private String threeDOfferedResponse;
    public static final String JSON_PROPERTY_XID = "xid";
    private String xid;

    public ThreeDS1Result cavv(String cavv) {
        this.cavv = cavv;
        return this;
    }

    @ApiModelProperty(value="The cardholder authentication value (base64 encoded).")
    @JsonProperty(value="cavv")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCavv() {
        return this.cavv;
    }

    @JsonProperty(value="cavv")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCavv(String cavv) {
        this.cavv = cavv;
    }

    public ThreeDS1Result cavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
        return this;
    }

    @ApiModelProperty(value="The CAVV algorithm used.")
    @JsonProperty(value="cavvAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCavvAlgorithm() {
        return this.cavvAlgorithm;
    }

    @JsonProperty(value="cavvAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
    }

    public ThreeDS1Result eci(String eci) {
        this.eci = eci;
        return this;
    }

    @ApiModelProperty(value="3D Secure Electronic Commerce Indicator (ECI).")
    @JsonProperty(value="eci")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEci() {
        return this.eci;
    }

    @JsonProperty(value="eci")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEci(String eci) {
        this.eci = eci;
    }

    public ThreeDS1Result threeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
        this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
        return this;
    }

    @ApiModelProperty(value="The authentication response from the ACS.")
    @JsonProperty(value="threeDAuthenticatedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDAuthenticatedResponse() {
        return this.threeDAuthenticatedResponse;
    }

    @JsonProperty(value="threeDAuthenticatedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
        this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
    }

    public ThreeDS1Result threeDOfferedResponse(String threeDOfferedResponse) {
        this.threeDOfferedResponse = threeDOfferedResponse;
        return this;
    }

    @ApiModelProperty(value="Whether 3D Secure was offered or not.")
    @JsonProperty(value="threeDOfferedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDOfferedResponse() {
        return this.threeDOfferedResponse;
    }

    @JsonProperty(value="threeDOfferedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDOfferedResponse(String threeDOfferedResponse) {
        this.threeDOfferedResponse = threeDOfferedResponse;
    }

    public ThreeDS1Result xid(String xid) {
        this.xid = xid;
        return this;
    }

    @ApiModelProperty(value="A unique transaction identifier generated by the MPI on behalf of the merchant to identify the 3D Secure transaction, in `Base64` encoding.")
    @JsonProperty(value="xid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getXid() {
        return this.xid;
    }

    @JsonProperty(value="xid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXid(String xid) {
        this.xid = xid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDS1Result threeDS1Result = (ThreeDS1Result)o;
        return Objects.equals(this.cavv, threeDS1Result.cavv) && Objects.equals(this.cavvAlgorithm, threeDS1Result.cavvAlgorithm) && Objects.equals(this.eci, threeDS1Result.eci) && Objects.equals(this.threeDAuthenticatedResponse, threeDS1Result.threeDAuthenticatedResponse) && Objects.equals(this.threeDOfferedResponse, threeDS1Result.threeDOfferedResponse) && Objects.equals(this.xid, threeDS1Result.xid);
    }

    public int hashCode() {
        return Objects.hash(this.cavv, this.cavvAlgorithm, this.eci, this.threeDAuthenticatedResponse, this.threeDOfferedResponse, this.xid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDS1Result {\n");
        sb.append("    cavv: ").append(this.toIndentedString(this.cavv)).append("\n");
        sb.append("    cavvAlgorithm: ").append(this.toIndentedString(this.cavvAlgorithm)).append("\n");
        sb.append("    eci: ").append(this.toIndentedString(this.eci)).append("\n");
        sb.append("    threeDAuthenticatedResponse: ").append(this.toIndentedString(this.threeDAuthenticatedResponse)).append("\n");
        sb.append("    threeDOfferedResponse: ").append(this.toIndentedString(this.threeDOfferedResponse)).append("\n");
        sb.append("    xid: ").append(this.toIndentedString(this.xid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ThreeDS1Result fromJson(String jsonString) throws JsonProcessingException {
        return (ThreeDS1Result)JSON.getMapper().readValue(jsonString, ThreeDS1Result.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

