/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.Amount;
import com.adyen.model.marketpayfund.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "destinationAccountCode", "merchantReference", "sourceAccountCode", "transferCode"})
public class TransferFundsRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
    private String destinationAccountCode;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
    private String sourceAccountCode;
    public static final String JSON_PROPERTY_TRANSFER_CODE = "transferCode";
    private String transferCode;

    public TransferFundsRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferFundsRequest destinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account to which the funds are to be credited. >The state of the Account Holder of this account must be Active.")
    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountCode() {
        return this.destinationAccountCode;
    }

    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
    }

    public TransferFundsRequest merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="A value that can be supplied at the discretion of the executing user in order to link multiple transactions to one another.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public TransferFundsRequest sourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account from which the funds are to be debited. >The state of the Account Holder of this account must be Active and allow payouts.")
    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountCode() {
        return this.sourceAccountCode;
    }

    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
    }

    public TransferFundsRequest transferCode(String transferCode) {
        this.transferCode = transferCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code related to the type of transfer being performed. >The permitted codes differ for each platform account and are defined in their service level agreement.")
    @JsonProperty(value="transferCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferCode() {
        return this.transferCode;
    }

    @JsonProperty(value="transferCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferCode(String transferCode) {
        this.transferCode = transferCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferFundsRequest transferFundsRequest = (TransferFundsRequest)o;
        return Objects.equals(this.amount, transferFundsRequest.amount) && Objects.equals(this.destinationAccountCode, transferFundsRequest.destinationAccountCode) && Objects.equals(this.merchantReference, transferFundsRequest.merchantReference) && Objects.equals(this.sourceAccountCode, transferFundsRequest.sourceAccountCode) && Objects.equals(this.transferCode, transferFundsRequest.transferCode);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.destinationAccountCode, this.merchantReference, this.sourceAccountCode, this.transferCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferFundsRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    destinationAccountCode: ").append(this.toIndentedString(this.destinationAccountCode)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    sourceAccountCode: ").append(this.toIndentedString(this.sourceAccountCode)).append("\n");
        sb.append("    transferCode: ").append(this.toIndentedString(this.transferCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferFundsRequest fromJson(String jsonString) throws JsonProcessingException {
        return (TransferFundsRequest)JSON.getMapper().readValue(jsonString, TransferFundsRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

