/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalCommission;
import com.adyen.model.management.Commission;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acquiringFees", "additionalCommission", "adyenCommission", "adyenFees", "adyenMarkup", "chargeback", "chargebackCostAllocation", "commission", "interchange", "paymentFee", "remainder", "schemeFee", "splitLogicId", "surcharge", "tip"})
public class UpdateSplitConfigurationLogicRequest {
    public static final String JSON_PROPERTY_ACQUIRING_FEES = "acquiringFees";
    private AcquiringFeesEnum acquiringFees;
    public static final String JSON_PROPERTY_ADDITIONAL_COMMISSION = "additionalCommission";
    private AdditionalCommission additionalCommission;
    public static final String JSON_PROPERTY_ADYEN_COMMISSION = "adyenCommission";
    private AdyenCommissionEnum adyenCommission;
    public static final String JSON_PROPERTY_ADYEN_FEES = "adyenFees";
    private AdyenFeesEnum adyenFees;
    public static final String JSON_PROPERTY_ADYEN_MARKUP = "adyenMarkup";
    private AdyenMarkupEnum adyenMarkup;
    public static final String JSON_PROPERTY_CHARGEBACK = "chargeback";
    private ChargebackEnum chargeback;
    public static final String JSON_PROPERTY_CHARGEBACK_COST_ALLOCATION = "chargebackCostAllocation";
    private ChargebackCostAllocationEnum chargebackCostAllocation;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Commission commission;
    public static final String JSON_PROPERTY_INTERCHANGE = "interchange";
    private InterchangeEnum interchange;
    public static final String JSON_PROPERTY_PAYMENT_FEE = "paymentFee";
    private PaymentFeeEnum paymentFee;
    public static final String JSON_PROPERTY_REMAINDER = "remainder";
    private RemainderEnum remainder;
    public static final String JSON_PROPERTY_SCHEME_FEE = "schemeFee";
    private SchemeFeeEnum schemeFee;
    public static final String JSON_PROPERTY_SPLIT_LOGIC_ID = "splitLogicId";
    private String splitLogicId;
    public static final String JSON_PROPERTY_SURCHARGE = "surcharge";
    private SurchargeEnum surcharge;
    public static final String JSON_PROPERTY_TIP = "tip";
    private TipEnum tip;

    public UpdateSplitConfigurationLogicRequest acquiringFees(AcquiringFeesEnum acquiringFees) {
        this.acquiringFees = acquiringFees;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the transaction fees. Should be combined with adyenFees.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="acquiringFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AcquiringFeesEnum getAcquiringFees() {
        return this.acquiringFees;
    }

    @JsonProperty(value="acquiringFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquiringFees(AcquiringFeesEnum acquiringFees) {
        this.acquiringFees = acquiringFees;
    }

    public UpdateSplitConfigurationLogicRequest additionalCommission(AdditionalCommission additionalCommission) {
        this.additionalCommission = additionalCommission;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="additionalCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdditionalCommission getAdditionalCommission() {
        return this.additionalCommission;
    }

    @JsonProperty(value="additionalCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalCommission(AdditionalCommission additionalCommission) {
        this.additionalCommission = additionalCommission;
    }

    public UpdateSplitConfigurationLogicRequest adyenCommission(AdyenCommissionEnum adyenCommission) {
        this.adyenCommission = adyenCommission;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the transaction fees. Should be combined with schemeFee, interchange & adyenMarkup.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="adyenCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdyenCommissionEnum getAdyenCommission() {
        return this.adyenCommission;
    }

    @JsonProperty(value="adyenCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdyenCommission(AdyenCommissionEnum adyenCommission) {
        this.adyenCommission = adyenCommission;
    }

    public UpdateSplitConfigurationLogicRequest adyenFees(AdyenFeesEnum adyenFees) {
        this.adyenFees = adyenFees;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the transaction fees. Should be combined with acquiringFees.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="adyenFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdyenFeesEnum getAdyenFees() {
        return this.adyenFees;
    }

    @JsonProperty(value="adyenFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdyenFees(AdyenFeesEnum adyenFees) {
        this.adyenFees = adyenFees;
    }

    public UpdateSplitConfigurationLogicRequest adyenMarkup(AdyenMarkupEnum adyenMarkup) {
        this.adyenMarkup = adyenMarkup;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the transaction fees. Should be combined with schemeFee, adyenCommission & interchange.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="adyenMarkup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdyenMarkupEnum getAdyenMarkup() {
        return this.adyenMarkup;
    }

    @JsonProperty(value="adyenMarkup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdyenMarkup(AdyenMarkupEnum adyenMarkup) {
        this.adyenMarkup = adyenMarkup;
    }

    public UpdateSplitConfigurationLogicRequest chargeback(ChargebackEnum chargeback) {
        this.chargeback = chargeback;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.")
    @JsonProperty(value="chargeback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChargebackEnum getChargeback() {
        return this.chargeback;
    }

    @JsonProperty(value="chargeback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargeback(ChargebackEnum chargeback) {
        this.chargeback = chargeback;
    }

    public UpdateSplitConfigurationLogicRequest chargebackCostAllocation(ChargebackCostAllocationEnum chargebackCostAllocation) {
        this.chargebackCostAllocation = chargebackCostAllocation;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when allocating the chargeback costs.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**")
    @JsonProperty(value="chargebackCostAllocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChargebackCostAllocationEnum getChargebackCostAllocation() {
        return this.chargebackCostAllocation;
    }

    @JsonProperty(value="chargebackCostAllocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargebackCostAllocation(ChargebackCostAllocationEnum chargebackCostAllocation) {
        this.chargebackCostAllocation = chargebackCostAllocation;
    }

    public UpdateSplitConfigurationLogicRequest commission(Commission commission) {
        this.commission = commission;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Commission getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommission(Commission commission) {
        this.commission = commission;
    }

    public UpdateSplitConfigurationLogicRequest interchange(InterchangeEnum interchange) {
        this.interchange = interchange;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the transaction fees. Should be combined with schemeFee, adyenCommission & adyenMarkup.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="interchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InterchangeEnum getInterchange() {
        return this.interchange;
    }

    @JsonProperty(value="interchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInterchange(InterchangeEnum interchange) {
        this.interchange = interchange;
    }

    public UpdateSplitConfigurationLogicRequest paymentFee(PaymentFeeEnum paymentFee) {
        this.paymentFee = paymentFee;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the transaction fees. Cannot be combined with other fees.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="paymentFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentFeeEnum getPaymentFee() {
        return this.paymentFee;
    }

    @JsonProperty(value="paymentFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentFee(PaymentFeeEnum paymentFee) {
        this.paymentFee = paymentFee;
    }

    public UpdateSplitConfigurationLogicRequest remainder(RemainderEnum remainder) {
        this.remainder = remainder;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the amount left over after currency conversion.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
    @JsonProperty(value="remainder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RemainderEnum getRemainder() {
        return this.remainder;
    }

    @JsonProperty(value="remainder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainder(RemainderEnum remainder) {
        this.remainder = remainder;
    }

    public UpdateSplitConfigurationLogicRequest schemeFee(SchemeFeeEnum schemeFee) {
        this.schemeFee = schemeFee;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the transaction fees. Should be combined with interchange, adyenCommission & adyenMarkup.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="schemeFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SchemeFeeEnum getSchemeFee() {
        return this.schemeFee;
    }

    @JsonProperty(value="schemeFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemeFee(SchemeFeeEnum schemeFee) {
        this.schemeFee = schemeFee;
    }

    public UpdateSplitConfigurationLogicRequest splitLogicId(String splitLogicId) {
        this.splitLogicId = splitLogicId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the split logic that is applied when the split configuration conditions are met.")
    @JsonProperty(value="splitLogicId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSplitLogicId() {
        return this.splitLogicId;
    }

    @JsonProperty(value="splitLogicId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitLogicId(String splitLogicId) {
        this.splitLogicId = splitLogicId;
    }

    public UpdateSplitConfigurationLogicRequest surcharge(SurchargeEnum surcharge) {
        this.surcharge = surcharge;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the surcharge amount.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**")
    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SurchargeEnum getSurcharge() {
        return this.surcharge;
    }

    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSurcharge(SurchargeEnum surcharge) {
        this.surcharge = surcharge;
    }

    public UpdateSplitConfigurationLogicRequest tip(TipEnum tip) {
        this.tip = tip;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking tips (gratuity).  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
    @JsonProperty(value="tip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TipEnum getTip() {
        return this.tip;
    }

    @JsonProperty(value="tip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTip(TipEnum tip) {
        this.tip = tip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSplitConfigurationLogicRequest updateSplitConfigurationLogicRequest = (UpdateSplitConfigurationLogicRequest)o;
        return Objects.equals((Object)this.acquiringFees, (Object)updateSplitConfigurationLogicRequest.acquiringFees) && Objects.equals(this.additionalCommission, updateSplitConfigurationLogicRequest.additionalCommission) && Objects.equals((Object)this.adyenCommission, (Object)updateSplitConfigurationLogicRequest.adyenCommission) && Objects.equals((Object)this.adyenFees, (Object)updateSplitConfigurationLogicRequest.adyenFees) && Objects.equals((Object)this.adyenMarkup, (Object)updateSplitConfigurationLogicRequest.adyenMarkup) && Objects.equals((Object)this.chargeback, (Object)updateSplitConfigurationLogicRequest.chargeback) && Objects.equals((Object)this.chargebackCostAllocation, (Object)updateSplitConfigurationLogicRequest.chargebackCostAllocation) && Objects.equals(this.commission, updateSplitConfigurationLogicRequest.commission) && Objects.equals((Object)this.interchange, (Object)updateSplitConfigurationLogicRequest.interchange) && Objects.equals((Object)this.paymentFee, (Object)updateSplitConfigurationLogicRequest.paymentFee) && Objects.equals((Object)this.remainder, (Object)updateSplitConfigurationLogicRequest.remainder) && Objects.equals((Object)this.schemeFee, (Object)updateSplitConfigurationLogicRequest.schemeFee) && Objects.equals(this.splitLogicId, updateSplitConfigurationLogicRequest.splitLogicId) && Objects.equals((Object)this.surcharge, (Object)updateSplitConfigurationLogicRequest.surcharge) && Objects.equals((Object)this.tip, (Object)updateSplitConfigurationLogicRequest.tip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquiringFees, this.additionalCommission, this.adyenCommission, this.adyenFees, this.adyenMarkup, this.chargeback, this.chargebackCostAllocation, this.commission, this.interchange, this.paymentFee, this.remainder, this.schemeFee, this.splitLogicId, this.surcharge, this.tip});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateSplitConfigurationLogicRequest {\n");
        sb.append("    acquiringFees: ").append(this.toIndentedString((Object)this.acquiringFees)).append("\n");
        sb.append("    additionalCommission: ").append(this.toIndentedString(this.additionalCommission)).append("\n");
        sb.append("    adyenCommission: ").append(this.toIndentedString((Object)this.adyenCommission)).append("\n");
        sb.append("    adyenFees: ").append(this.toIndentedString((Object)this.adyenFees)).append("\n");
        sb.append("    adyenMarkup: ").append(this.toIndentedString((Object)this.adyenMarkup)).append("\n");
        sb.append("    chargeback: ").append(this.toIndentedString((Object)this.chargeback)).append("\n");
        sb.append("    chargebackCostAllocation: ").append(this.toIndentedString((Object)this.chargebackCostAllocation)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    interchange: ").append(this.toIndentedString((Object)this.interchange)).append("\n");
        sb.append("    paymentFee: ").append(this.toIndentedString((Object)this.paymentFee)).append("\n");
        sb.append("    remainder: ").append(this.toIndentedString((Object)this.remainder)).append("\n");
        sb.append("    schemeFee: ").append(this.toIndentedString((Object)this.schemeFee)).append("\n");
        sb.append("    splitLogicId: ").append(this.toIndentedString(this.splitLogicId)).append("\n");
        sb.append("    surcharge: ").append(this.toIndentedString((Object)this.surcharge)).append("\n");
        sb.append("    tip: ").append(this.toIndentedString((Object)this.tip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateSplitConfigurationLogicRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateSplitConfigurationLogicRequest)JSON.getMapper().readValue(jsonString, UpdateSplitConfigurationLogicRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TipEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private TipEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TipEnum fromValue(String value) {
            for (TipEnum b : TipEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SurchargeEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private SurchargeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SurchargeEnum fromValue(String value) {
            for (SurchargeEnum b : SurchargeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SchemeFeeEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private SchemeFeeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SchemeFeeEnum fromValue(String value) {
            for (SchemeFeeEnum b : SchemeFeeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RemainderEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private RemainderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RemainderEnum fromValue(String value) {
            for (RemainderEnum b : RemainderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentFeeEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private PaymentFeeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentFeeEnum fromValue(String value) {
            for (PaymentFeeEnum b : PaymentFeeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InterchangeEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private InterchangeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InterchangeEnum fromValue(String value) {
            for (InterchangeEnum b : InterchangeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChargebackCostAllocationEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private ChargebackCostAllocationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChargebackCostAllocationEnum fromValue(String value) {
            for (ChargebackCostAllocationEnum b : ChargebackCostAllocationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChargebackEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount"),
        DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio");

        private String value;

        private ChargebackEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChargebackEnum fromValue(String value) {
            for (ChargebackEnum b : ChargebackEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AdyenMarkupEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AdyenMarkupEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdyenMarkupEnum fromValue(String value) {
            for (AdyenMarkupEnum b : AdyenMarkupEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AdyenFeesEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AdyenFeesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdyenFeesEnum fromValue(String value) {
            for (AdyenFeesEnum b : AdyenFeesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AdyenCommissionEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AdyenCommissionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdyenCommissionEnum fromValue(String value) {
            for (AdyenCommissionEnum b : AdyenCommissionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AcquiringFeesEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AcquiringFeesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AcquiringFeesEnum fromValue(String value) {
            for (AcquiringFeesEnum b : AcquiringFeesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

