/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantId", "output", "requestSent", "responseCode", "responseTime", "status"})
public class TestOutput {
    public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
    private String merchantId;
    public static final String JSON_PROPERTY_OUTPUT = "output";
    private String output;
    public static final String JSON_PROPERTY_REQUEST_SENT = "requestSent";
    private String requestSent;
    public static final String JSON_PROPERTY_RESPONSE_CODE = "responseCode";
    private String responseCode;
    public static final String JSON_PROPERTY_RESPONSE_TIME = "responseTime";
    private String responseTime;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public TestOutput merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the merchant account that the notification is about.")
    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public TestOutput output(String output) {
        this.output = output;
        return this;
    }

    @ApiModelProperty(value="The response your server returned for the test webhook.  Your server must respond with **[accepted]** for the test webhook to be successful (`data.status`: **success**). Find out more about [accepting notifications](https://docs.adyen.com/development-resources/webhooks#accept-notifications)  You can use the value of this field together with the [`responseCode`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-responseCode) value to troubleshoot unsuccessful test webhooks.")
    @JsonProperty(value="output")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutput(String output) {
        this.output = output;
    }

    public TestOutput requestSent(String requestSent) {
        this.requestSent = requestSent;
        return this;
    }

    @ApiModelProperty(value="The [body of the notification webhook](https://docs.adyen.com/development-resources/webhooks/understand-notifications#notification-structure) that was sent to your server.")
    @JsonProperty(value="requestSent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestSent() {
        return this.requestSent;
    }

    @JsonProperty(value="requestSent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestSent(String requestSent) {
        this.requestSent = requestSent;
    }

    public TestOutput responseCode(String responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    @ApiModelProperty(example="200", value="The HTTP response code for your server's response to the test webhook.  You can use the value of this field together with the the [`output`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-output) field value to troubleshoot failed test webhooks.")
    @JsonProperty(value="responseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponseCode() {
        return this.responseCode;
    }

    @JsonProperty(value="responseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public TestOutput responseTime(String responseTime) {
        this.responseTime = responseTime;
        return this;
    }

    @ApiModelProperty(value="The time between sending the test webhook and receiving the response from your server. You can use it as an indication of how long your server takes to process a webhook notification. Measured in milliseconds, for example **304 ms**.")
    @JsonProperty(value="responseTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponseTime() {
        return this.responseTime;
    }

    @JsonProperty(value="responseTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseTime(String responseTime) {
        this.responseTime = responseTime;
    }

    public TestOutput status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the test request. Possible values are: * **success**, if `data.output`: **[accepted]** and `data.responseCode`: **200**. * **failed**, in all other cases.  You can use the value of the [`output`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-output) field together with the [`responseCode`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-responseCode) value to troubleshoot failed test webhooks.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestOutput testOutput = (TestOutput)o;
        return Objects.equals(this.merchantId, testOutput.merchantId) && Objects.equals(this.output, testOutput.output) && Objects.equals(this.requestSent, testOutput.requestSent) && Objects.equals(this.responseCode, testOutput.responseCode) && Objects.equals(this.responseTime, testOutput.responseTime) && Objects.equals(this.status, testOutput.status);
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.output, this.requestSent, this.responseCode, this.responseTime, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestOutput {\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    requestSent: ").append(this.toIndentedString(this.requestSent)).append("\n");
        sb.append("    responseCode: ").append(this.toIndentedString(this.responseCode)).append("\n");
        sb.append("    responseTime: ").append(this.toIndentedString(this.responseTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TestOutput fromJson(String jsonString) throws JsonProcessingException {
        return (TestOutput)JSON.getMapper().readValue(jsonString, TestOutput.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

