/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.OrderItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"billingEntityId", "customerOrderReference", "items", "orderType", "shippingLocationId", "taxId"})
public class TerminalOrderRequest {
    public static final String JSON_PROPERTY_BILLING_ENTITY_ID = "billingEntityId";
    private String billingEntityId;
    public static final String JSON_PROPERTY_CUSTOMER_ORDER_REFERENCE = "customerOrderReference";
    private String customerOrderReference;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<OrderItem> items = null;
    public static final String JSON_PROPERTY_ORDER_TYPE = "orderType";
    private String orderType;
    public static final String JSON_PROPERTY_SHIPPING_LOCATION_ID = "shippingLocationId";
    private String shippingLocationId;
    public static final String JSON_PROPERTY_TAX_ID = "taxId";
    private String taxId;

    public TerminalOrderRequest billingEntityId(String billingEntityId) {
        this.billingEntityId = billingEntityId;
        return this;
    }

    @ApiModelProperty(value="The identification of the billing entity to use for the order.")
    @JsonProperty(value="billingEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBillingEntityId() {
        return this.billingEntityId;
    }

    @JsonProperty(value="billingEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingEntityId(String billingEntityId) {
        this.billingEntityId = billingEntityId;
    }

    public TerminalOrderRequest customerOrderReference(String customerOrderReference) {
        this.customerOrderReference = customerOrderReference;
        return this;
    }

    @ApiModelProperty(value="The merchant-defined purchase order reference.")
    @JsonProperty(value="customerOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerOrderReference() {
        return this.customerOrderReference;
    }

    @JsonProperty(value="customerOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerOrderReference(String customerOrderReference) {
        this.customerOrderReference = customerOrderReference;
    }

    public TerminalOrderRequest items(List<OrderItem> items) {
        this.items = items;
        return this;
    }

    public TerminalOrderRequest addItemsItem(OrderItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<OrderItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="The products included in the order.")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OrderItem> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    public TerminalOrderRequest orderType(String orderType) {
        this.orderType = orderType;
        return this;
    }

    @ApiModelProperty(value="Type of order")
    @JsonProperty(value="orderType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderType() {
        return this.orderType;
    }

    @JsonProperty(value="orderType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public TerminalOrderRequest shippingLocationId(String shippingLocationId) {
        this.shippingLocationId = shippingLocationId;
        return this;
    }

    @ApiModelProperty(value="The identification of the shipping location to use for the order.")
    @JsonProperty(value="shippingLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShippingLocationId() {
        return this.shippingLocationId;
    }

    @JsonProperty(value="shippingLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShippingLocationId(String shippingLocationId) {
        this.shippingLocationId = shippingLocationId;
    }

    public TerminalOrderRequest taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The tax number of the billing entity.")
    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaxId() {
        return this.taxId;
    }

    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalOrderRequest terminalOrderRequest = (TerminalOrderRequest)o;
        return Objects.equals(this.billingEntityId, terminalOrderRequest.billingEntityId) && Objects.equals(this.customerOrderReference, terminalOrderRequest.customerOrderReference) && Objects.equals(this.items, terminalOrderRequest.items) && Objects.equals(this.orderType, terminalOrderRequest.orderType) && Objects.equals(this.shippingLocationId, terminalOrderRequest.shippingLocationId) && Objects.equals(this.taxId, terminalOrderRequest.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.billingEntityId, this.customerOrderReference, this.items, this.orderType, this.shippingLocationId, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalOrderRequest {\n");
        sb.append("    billingEntityId: ").append(this.toIndentedString(this.billingEntityId)).append("\n");
        sb.append("    customerOrderReference: ").append(this.toIndentedString(this.customerOrderReference)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    orderType: ").append(this.toIndentedString(this.orderType)).append("\n");
        sb.append("    shippingLocationId: ").append(this.toIndentedString(this.shippingLocationId)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TerminalOrderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (TerminalOrderRequest)JSON.getMapper().readValue(jsonString, TerminalOrderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

