/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.legalentitymanagement.TransferInstrument;
import com.adyen.model.legalentitymanagement.TransferInstrumentInfo;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TransferInstrumentsApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public TransferInstrumentsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    public TransferInstrumentsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void deleteTransferInstrument(String id) throws ApiException, IOException {
        this.deleteTransferInstrument(id, null);
    }

    public void deleteTransferInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transferInstruments/{id}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public TransferInstrument getTransferInstrument(String id) throws ApiException, IOException {
        return this.getTransferInstrument(id, null);
    }

    public TransferInstrument getTransferInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transferInstruments/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransferInstrument.fromJson(jsonResult);
    }

    public TransferInstrument updateTransferInstrument(String id, TransferInstrumentInfo transferInstrumentInfo) throws ApiException, IOException {
        return this.updateTransferInstrument(id, transferInstrumentInfo, null);
    }

    public TransferInstrument updateTransferInstrument(String id, TransferInstrumentInfo transferInstrumentInfo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = transferInstrumentInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transferInstruments/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TransferInstrument.fromJson(jsonResult);
    }

    public TransferInstrument createTransferInstrument(TransferInstrumentInfo transferInstrumentInfo) throws ApiException, IOException {
        return this.createTransferInstrument(transferInstrumentInfo, null);
    }

    public TransferInstrument createTransferInstrument(TransferInstrumentInfo transferInstrumentInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = transferInstrumentInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transferInstruments", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return TransferInstrument.fromJson(jsonResult);
    }
}

