/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountIdentifier", "id", "realLastFour", "trustedSource"})
public class TransferInstrumentReference {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private String accountIdentifier;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_REAL_LAST_FOUR = "realLastFour";
    private String realLastFour;
    public static final String JSON_PROPERTY_TRUSTED_SOURCE = "trustedSource";
    private Boolean trustedSource;

    public TransferInstrumentReference accountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @ApiModelProperty(required=true, value="The masked IBAN or bank account number.")
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public TransferInstrumentReference id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the resource.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TransferInstrumentReference realLastFour(String realLastFour) {
        this.realLastFour = realLastFour;
        return this;
    }

    @ApiModelProperty(value="Four last digits of the bank account number.")
    @JsonProperty(value="realLastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRealLastFour() {
        return this.realLastFour;
    }

    @JsonProperty(value="realLastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRealLastFour(String realLastFour) {
        this.realLastFour = realLastFour;
    }

    public TransferInstrumentReference trustedSource(Boolean trustedSource) {
        this.trustedSource = trustedSource;
        return this;
    }

    @ApiModelProperty(value="Identifies if the bank account was created through [instant bank verification](https://docs.adyen.com/release-notes/platforms-and-financial-products#releaseNote=2023-05-08-hosted-onboarding).")
    @JsonProperty(value="trustedSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTrustedSource() {
        return this.trustedSource;
    }

    @JsonProperty(value="trustedSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrustedSource(Boolean trustedSource) {
        this.trustedSource = trustedSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInstrumentReference transferInstrumentReference = (TransferInstrumentReference)o;
        return Objects.equals(this.accountIdentifier, transferInstrumentReference.accountIdentifier) && Objects.equals(this.id, transferInstrumentReference.id) && Objects.equals(this.realLastFour, transferInstrumentReference.realLastFour) && Objects.equals(this.trustedSource, transferInstrumentReference.trustedSource);
    }

    public int hashCode() {
        return Objects.hash(this.accountIdentifier, this.id, this.realLastFour, this.trustedSource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferInstrumentReference {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    realLastFour: ").append(this.toIndentedString(this.realLastFour)).append("\n");
        sb.append("    trustedSource: ").append(this.toIndentedString(this.trustedSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferInstrumentReference fromJson(String jsonString) throws JsonProcessingException {
        return (TransferInstrumentReference)JSON.getMapper().readValue(jsonString, TransferInstrumentReference.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

