/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"maxValue", "plans", "preselectedValue", "values"})
public class InstallmentOption {
    public static final String JSON_PROPERTY_MAX_VALUE = "maxValue";
    private Integer maxValue;
    public static final String JSON_PROPERTY_PLANS = "plans";
    private List<PlansEnum> plans = null;
    public static final String JSON_PROPERTY_PRESELECTED_VALUE = "preselectedValue";
    private Integer preselectedValue;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<Integer> values = null;

    public InstallmentOption maxValue(Integer maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    @ApiModelProperty(value="The maximum number of installments offered for this payment method.")
    @JsonProperty(value="maxValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxValue() {
        return this.maxValue;
    }

    @JsonProperty(value="maxValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public InstallmentOption plans(List<PlansEnum> plans) {
        this.plans = plans;
        return this;
    }

    public InstallmentOption addPlansItem(PlansEnum plansItem) {
        if (this.plans == null) {
            this.plans = new ArrayList<PlansEnum>();
        }
        this.plans.add(plansItem);
        return this;
    }

    @ApiModelProperty(value="Defines the type of installment plan. If not set, defaults to **regular**.  Possible values: * **regular** * **revolving**")
    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PlansEnum> getPlans() {
        return this.plans;
    }

    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlans(List<PlansEnum> plans) {
        this.plans = plans;
    }

    public InstallmentOption preselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
        return this;
    }

    @ApiModelProperty(value="Preselected number of installments offered for this payment method.")
    @JsonProperty(value="preselectedValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPreselectedValue() {
        return this.preselectedValue;
    }

    @JsonProperty(value="preselectedValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
    }

    public InstallmentOption values(List<Integer> values) {
        this.values = values;
        return this;
    }

    public InstallmentOption addValuesItem(Integer valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(value="An array of the number of installments that the shopper can choose from. For example, **[2,3,5]**. This cannot be specified simultaneously with `maxValue`.")
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallmentOption installmentOption = (InstallmentOption)o;
        return Objects.equals(this.maxValue, installmentOption.maxValue) && Objects.equals(this.plans, installmentOption.plans) && Objects.equals(this.preselectedValue, installmentOption.preselectedValue) && Objects.equals(this.values, installmentOption.values);
    }

    public int hashCode() {
        return Objects.hash(this.maxValue, this.plans, this.preselectedValue, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstallmentOption {\n");
        sb.append("    maxValue: ").append(this.toIndentedString(this.maxValue)).append("\n");
        sb.append("    plans: ").append(this.toIndentedString(this.plans)).append("\n");
        sb.append("    preselectedValue: ").append(this.toIndentedString(this.preselectedValue)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static InstallmentOption fromJson(String jsonString) throws JsonProcessingException {
        return (InstallmentOption)JSON.getMapper().readValue(jsonString, InstallmentOption.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PlansEnum {
        REGULAR("regular"),
        REVOLVING("revolving");

        private String value;

        private PlansEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlansEnum fromValue(String value) {
            for (PlansEnum b : PlansEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

