/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.DeviceInfo;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"brandVariant", "creationDate", "device", "id", "paymentInstrumentId", "status", "tokenLastFour", "type"})
public class NetworkToken {
    public static final String JSON_PROPERTY_BRAND_VARIANT = "brandVariant";
    private String brandVariant;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_DEVICE = "device";
    private DeviceInfo device;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TOKEN_LAST_FOUR = "tokenLastFour";
    private String tokenLastFour;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public NetworkToken brandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
        return this;
    }

    @ApiModelProperty(value="The card brand variant of the payment instrument associated with the network token. For example, **mc_prepaid_mrw**.")
    @JsonProperty(value="brandVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrandVariant() {
        return this.brandVariant;
    }

    @JsonProperty(value="brandVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
    }

    public NetworkToken creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="Date and time when the network token was created, in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) extended format. For example, **2020-12-18T10:15:30+01:00**..")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public NetworkToken device(DeviceInfo device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeviceInfo getDevice() {
        return this.device;
    }

    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDevice(DeviceInfo device) {
        this.device = device;
    }

    public NetworkToken id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the network token.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public NetworkToken paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the payment instrument to which this network token belongs to.")
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public NetworkToken status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the network token. Possible values: **active**, **inactive**, **suspended**, **closed**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public NetworkToken tokenLastFour(String tokenLastFour) {
        this.tokenLastFour = tokenLastFour;
        return this;
    }

    @ApiModelProperty(value="The last four digits of the network token `id`.")
    @JsonProperty(value="tokenLastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenLastFour() {
        return this.tokenLastFour;
    }

    @JsonProperty(value="tokenLastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenLastFour(String tokenLastFour) {
        this.tokenLastFour = tokenLastFour;
    }

    public NetworkToken type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of wallet the network token is associated with. For example, **applePay**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkToken networkToken = (NetworkToken)o;
        return Objects.equals(this.brandVariant, networkToken.brandVariant) && Objects.equals(this.creationDate, networkToken.creationDate) && Objects.equals(this.device, networkToken.device) && Objects.equals(this.id, networkToken.id) && Objects.equals(this.paymentInstrumentId, networkToken.paymentInstrumentId) && Objects.equals((Object)this.status, (Object)networkToken.status) && Objects.equals(this.tokenLastFour, networkToken.tokenLastFour) && Objects.equals(this.type, networkToken.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brandVariant, this.creationDate, this.device, this.id, this.paymentInstrumentId, this.status, this.tokenLastFour, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkToken {\n");
        sb.append("    brandVariant: ").append(this.toIndentedString(this.brandVariant)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tokenLastFour: ").append(this.toIndentedString(this.tokenLastFour)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NetworkToken fromJson(String jsonString) throws JsonProcessingException {
        return (NetworkToken)JSON.getMapper().readValue(jsonString, NetworkToken.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive"),
        SUSPENDED("suspended"),
        CLOSED("closed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

