/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Balance;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.PlatformPaymentConfiguration;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderId", "balances", "defaultCurrencyCode", "description", "id", "metadata", "migratedAccountCode", "platformPaymentConfiguration", "reference", "status", "timeZone"})
public class BalanceAccount {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
    private String accountHolderId;
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private List<Balance> balances = null;
    public static final String JSON_PROPERTY_DEFAULT_CURRENCY_CODE = "defaultCurrencyCode";
    private String defaultCurrencyCode;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_MIGRATED_ACCOUNT_CODE = "migratedAccountCode";
    private String migratedAccountCode;
    public static final String JSON_PROPERTY_PLATFORM_PAYMENT_CONFIGURATION = "platformPaymentConfiguration";
    private PlatformPaymentConfiguration platformPaymentConfiguration;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TIME_ZONE = "timeZone";
    private String timeZone;

    public BalanceAccount accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [account holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id) associated with the balance account.")
    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public BalanceAccount balances(List<Balance> balances) {
        this.balances = balances;
        return this;
    }

    public BalanceAccount addBalancesItem(Balance balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<Balance>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @ApiModelProperty(value="List of balances with the amount and currency.")
    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Balance> getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(List<Balance> balances) {
        this.balances = balances;
    }

    public BalanceAccount defaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
        return this;
    }

    @ApiModelProperty(value="The default three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance account. The default value is **EUR**.")
    @JsonProperty(value="defaultCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultCurrencyCode() {
        return this.defaultCurrencyCode;
    }

    @JsonProperty(value="defaultCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
    }

    public BalanceAccount description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A human-readable description of the balance account, maximum 300 characters. You can use this parameter to distinguish between multiple balance accounts under an account holder.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public BalanceAccount id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the balance account.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BalanceAccount metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BalanceAccount putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BalanceAccount migratedAccountCode(String migratedAccountCode) {
        this.migratedAccountCode = migratedAccountCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the account of the migrated account holder in the classic integration.")
    @JsonProperty(value="migratedAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMigratedAccountCode() {
        return this.migratedAccountCode;
    }

    @JsonProperty(value="migratedAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigratedAccountCode(String migratedAccountCode) {
        this.migratedAccountCode = migratedAccountCode;
    }

    public BalanceAccount platformPaymentConfiguration(PlatformPaymentConfiguration platformPaymentConfiguration) {
        this.platformPaymentConfiguration = platformPaymentConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="platformPaymentConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformPaymentConfiguration getPlatformPaymentConfiguration() {
        return this.platformPaymentConfiguration;
    }

    @JsonProperty(value="platformPaymentConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformPaymentConfiguration(PlatformPaymentConfiguration platformPaymentConfiguration) {
        this.platformPaymentConfiguration = platformPaymentConfiguration;
    }

    public BalanceAccount reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the balance account, maximum 150 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceAccount status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the balance account, set to **active** by default.  ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BalanceAccount timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the balance account. For example, **Europe/Amsterdam**. Defaults to the time zone of the account holder if no time zone is set. For possible values, see the [list of time zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).")
    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceAccount balanceAccount = (BalanceAccount)o;
        return Objects.equals(this.accountHolderId, balanceAccount.accountHolderId) && Objects.equals(this.balances, balanceAccount.balances) && Objects.equals(this.defaultCurrencyCode, balanceAccount.defaultCurrencyCode) && Objects.equals(this.description, balanceAccount.description) && Objects.equals(this.id, balanceAccount.id) && Objects.equals(this.metadata, balanceAccount.metadata) && Objects.equals(this.migratedAccountCode, balanceAccount.migratedAccountCode) && Objects.equals(this.platformPaymentConfiguration, balanceAccount.platformPaymentConfiguration) && Objects.equals(this.reference, balanceAccount.reference) && Objects.equals((Object)this.status, (Object)balanceAccount.status) && Objects.equals(this.timeZone, balanceAccount.timeZone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.balances, this.defaultCurrencyCode, this.description, this.id, this.metadata, this.migratedAccountCode, this.platformPaymentConfiguration, this.reference, this.status, this.timeZone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceAccount {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    defaultCurrencyCode: ").append(this.toIndentedString(this.defaultCurrencyCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    migratedAccountCode: ").append(this.toIndentedString(this.migratedAccountCode)).append("\n");
        sb.append("    platformPaymentConfiguration: ").append(this.toIndentedString(this.platformPaymentConfiguration)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceAccount fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceAccount)JSON.getMapper().readValue(jsonString, BalanceAccount.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        INACTIVE("inactive"),
        SUSPENDED("suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

