/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.ApiCredential;
import com.adyen.model.management.CreateApiCredentialResponse;
import com.adyen.model.management.CreateMerchantApiCredentialRequest;
import com.adyen.model.management.ListMerchantApiCredentialsResponse;
import com.adyen.model.management.UpdateMerchantApiCredentialRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class ApiCredentialsMerchantLevelApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public ApiCredentialsMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v1");
    }

    public ApiCredentialsMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public ListMerchantApiCredentialsResponse listApiCredentials(String merchantId) throws ApiException, IOException {
        return this.listApiCredentials(merchantId, null, null, null);
    }

    public ListMerchantApiCredentialsResponse listApiCredentials(String merchantId, Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/apiCredentials", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListMerchantApiCredentialsResponse.fromJson(jsonResult);
    }

    public ApiCredential getApiCredential(String merchantId, String apiCredentialId) throws ApiException, IOException {
        return this.getApiCredential(merchantId, apiCredentialId, null);
    }

    public ApiCredential getApiCredential(String merchantId, String apiCredentialId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/apiCredentials/{apiCredentialId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return ApiCredential.fromJson(jsonResult);
    }

    public ApiCredential updateApiCredential(String merchantId, String apiCredentialId, UpdateMerchantApiCredentialRequest updateMerchantApiCredentialRequest) throws ApiException, IOException {
        return this.updateApiCredential(merchantId, apiCredentialId, updateMerchantApiCredentialRequest, null);
    }

    public ApiCredential updateApiCredential(String merchantId, String apiCredentialId, UpdateMerchantApiCredentialRequest updateMerchantApiCredentialRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = updateMerchantApiCredentialRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/apiCredentials/{apiCredentialId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return ApiCredential.fromJson(jsonResult);
    }

    public CreateApiCredentialResponse createApiCredential(String merchantId, CreateMerchantApiCredentialRequest createMerchantApiCredentialRequest) throws ApiException, IOException {
        return this.createApiCredential(merchantId, createMerchantApiCredentialRequest, null);
    }

    public CreateApiCredentialResponse createApiCredential(String merchantId, CreateMerchantApiCredentialRequest createMerchantApiCredentialRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = createMerchantApiCredentialRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/apiCredentials", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return CreateApiCredentialResponse.fromJson(jsonResult);
    }
}

