/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.legalentitymanagement.BusinessLine;
import com.adyen.model.legalentitymanagement.BusinessLineInfo;
import com.adyen.model.legalentitymanagement.BusinessLineInfoUpdate;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class BusinessLinesApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public BusinessLinesApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    public BusinessLinesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void deleteBusinessLine(String id) throws ApiException, IOException {
        this.deleteBusinessLine(id, null);
    }

    public void deleteBusinessLine(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/businessLines/{id}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public BusinessLine getBusinessLine(String id) throws ApiException, IOException {
        return this.getBusinessLine(id, null);
    }

    public BusinessLine getBusinessLine(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/businessLines/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return BusinessLine.fromJson(jsonResult);
    }

    public BusinessLine updateBusinessLine(String id, BusinessLineInfoUpdate businessLineInfoUpdate) throws ApiException, IOException {
        return this.updateBusinessLine(id, businessLineInfoUpdate, null);
    }

    public BusinessLine updateBusinessLine(String id, BusinessLineInfoUpdate businessLineInfoUpdate, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = businessLineInfoUpdate.toJson();
        Resource resource = new Resource(this, this.baseURL + "/businessLines/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return BusinessLine.fromJson(jsonResult);
    }

    public BusinessLine createBusinessLine(BusinessLineInfo businessLineInfo) throws ApiException, IOException {
        return this.createBusinessLine(businessLineInfo, null);
    }

    public BusinessLine createBusinessLine(BusinessLineInfo businessLineInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = businessLineInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/businessLines", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return BusinessLine.fromJson(jsonResult);
    }
}

