/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Counterparty2;
import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"counterparty", "grantAccountId", "grantOfferId"})
public class CapitalGrantInfo {
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private Counterparty2 counterparty;
    public static final String JSON_PROPERTY_GRANT_ACCOUNT_ID = "grantAccountId";
    private String grantAccountId;
    public static final String JSON_PROPERTY_GRANT_OFFER_ID = "grantOfferId";
    private String grantOfferId;

    public CapitalGrantInfo counterparty(Counterparty2 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Counterparty2 getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(Counterparty2 counterparty) {
        this.counterparty = counterparty;
    }

    public CapitalGrantInfo grantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the grant account used for the grant.")
    @JsonProperty(value="grantAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGrantAccountId() {
        return this.grantAccountId;
    }

    @JsonProperty(value="grantAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
    }

    public CapitalGrantInfo grantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the grant offer that has been selected and from which the grant details will be used.")
    @JsonProperty(value="grantOfferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGrantOfferId() {
        return this.grantOfferId;
    }

    @JsonProperty(value="grantOfferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalGrantInfo capitalGrantInfo = (CapitalGrantInfo)o;
        return Objects.equals(this.counterparty, capitalGrantInfo.counterparty) && Objects.equals(this.grantAccountId, capitalGrantInfo.grantAccountId) && Objects.equals(this.grantOfferId, capitalGrantInfo.grantOfferId);
    }

    public int hashCode() {
        return Objects.hash(this.counterparty, this.grantAccountId, this.grantOfferId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalGrantInfo {\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    grantAccountId: ").append(this.toIndentedString(this.grantAccountId)).append("\n");
        sb.append("    grantOfferId: ").append(this.toIndentedString(this.grantOfferId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CapitalGrantInfo fromJson(String jsonString) throws JsonProcessingException {
        return (CapitalGrantInfo)JSON.getMapper().readValue(jsonString, CapitalGrantInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

