/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"assigned", "bluetoothIp", "bluetoothMac", "city", "companyAccount", "countryCode", "deviceModel", "ethernetIp", "ethernetMac", "firmwareVersion", "iccid", "id", "lastActivityDateTime", "lastTransactionDateTime", "linkNegotiation", "serialNumber", "simStatus", "status", "storeStatus", "wifiIp", "wifiMac", "wifiSsid"})
public class Terminal {
    public static final String JSON_PROPERTY_ASSIGNED = "assigned";
    private Boolean assigned;
    public static final String JSON_PROPERTY_BLUETOOTH_IP = "bluetoothIp";
    private String bluetoothIp;
    public static final String JSON_PROPERTY_BLUETOOTH_MAC = "bluetoothMac";
    private String bluetoothMac;
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_COMPANY_ACCOUNT = "companyAccount";
    private String companyAccount;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_DEVICE_MODEL = "deviceModel";
    private String deviceModel;
    public static final String JSON_PROPERTY_ETHERNET_IP = "ethernetIp";
    private String ethernetIp;
    public static final String JSON_PROPERTY_ETHERNET_MAC = "ethernetMac";
    private String ethernetMac;
    public static final String JSON_PROPERTY_FIRMWARE_VERSION = "firmwareVersion";
    private String firmwareVersion;
    public static final String JSON_PROPERTY_ICCID = "iccid";
    private String iccid;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_ACTIVITY_DATE_TIME = "lastActivityDateTime";
    private OffsetDateTime lastActivityDateTime;
    public static final String JSON_PROPERTY_LAST_TRANSACTION_DATE_TIME = "lastTransactionDateTime";
    private OffsetDateTime lastTransactionDateTime;
    public static final String JSON_PROPERTY_LINK_NEGOTIATION = "linkNegotiation";
    private String linkNegotiation;
    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber;
    public static final String JSON_PROPERTY_SIM_STATUS = "simStatus";
    private String simStatus;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_STORE_STATUS = "storeStatus";
    private String storeStatus;
    public static final String JSON_PROPERTY_WIFI_IP = "wifiIp";
    private String wifiIp;
    public static final String JSON_PROPERTY_WIFI_MAC = "wifiMac";
    private String wifiMac;
    public static final String JSON_PROPERTY_WIFI_SSID = "wifiSsid";
    private String wifiSsid;

    public Terminal assigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    @ApiModelProperty(value="The [assignment status](https://docs.adyen.com/point-of-sale/automating-terminal-management/assign-terminals-api) of the terminal. If true, the terminal is assigned. If false, the terminal is in inventory and can't be boarded.")
    @JsonProperty(value="assigned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAssigned() {
        return this.assigned;
    }

    @JsonProperty(value="assigned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public Terminal bluetoothIp(String bluetoothIp) {
        this.bluetoothIp = bluetoothIp;
        return this;
    }

    @ApiModelProperty(value="The Bluetooth IP address of the terminal.")
    @JsonProperty(value="bluetoothIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBluetoothIp() {
        return this.bluetoothIp;
    }

    @JsonProperty(value="bluetoothIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBluetoothIp(String bluetoothIp) {
        this.bluetoothIp = bluetoothIp;
    }

    public Terminal bluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
        return this;
    }

    @ApiModelProperty(value="The Bluetooth MAC address of the terminal.")
    @JsonProperty(value="bluetoothMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBluetoothMac() {
        return this.bluetoothMac;
    }

    @JsonProperty(value="bluetoothMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
    }

    public Terminal city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The city where the terminal is located.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public Terminal companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(value="The company account that the terminal is associated with. If this is the only account level shown in the response, the terminal is assigned to the inventory of the company account.")
    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public Terminal countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The country code of the country where the terminal is located.")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Terminal deviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    @ApiModelProperty(value="The model name of the terminal.")
    @JsonProperty(value="deviceModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @JsonProperty(value="deviceModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public Terminal ethernetIp(String ethernetIp) {
        this.ethernetIp = ethernetIp;
        return this;
    }

    @ApiModelProperty(value="The ethernet IP address of the terminal.")
    @JsonProperty(value="ethernetIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEthernetIp() {
        return this.ethernetIp;
    }

    @JsonProperty(value="ethernetIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEthernetIp(String ethernetIp) {
        this.ethernetIp = ethernetIp;
    }

    public Terminal ethernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
        return this;
    }

    @ApiModelProperty(value="The ethernet MAC address of the terminal.")
    @JsonProperty(value="ethernetMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEthernetMac() {
        return this.ethernetMac;
    }

    @JsonProperty(value="ethernetMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEthernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
    }

    public Terminal firmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        return this;
    }

    @ApiModelProperty(value="The software release currently in use on the terminal.")
    @JsonProperty(value="firmwareVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @JsonProperty(value="firmwareVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public Terminal iccid(String iccid) {
        this.iccid = iccid;
        return this;
    }

    @ApiModelProperty(value="The integrated circuit card identifier (ICCID) of the SIM card in the terminal.")
    @JsonProperty(value="iccid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIccid() {
        return this.iccid;
    }

    @JsonProperty(value="iccid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public Terminal id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the terminal.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Terminal lastActivityDateTime(OffsetDateTime lastActivityDateTime) {
        this.lastActivityDateTime = lastActivityDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.")
    @JsonProperty(value="lastActivityDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastActivityDateTime() {
        return this.lastActivityDateTime;
    }

    @JsonProperty(value="lastActivityDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastActivityDateTime(OffsetDateTime lastActivityDateTime) {
        this.lastActivityDateTime = lastActivityDateTime;
    }

    public Terminal lastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
        this.lastTransactionDateTime = lastTransactionDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.")
    @JsonProperty(value="lastTransactionDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastTransactionDateTime() {
        return this.lastTransactionDateTime;
    }

    @JsonProperty(value="lastTransactionDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
        this.lastTransactionDateTime = lastTransactionDateTime;
    }

    public Terminal linkNegotiation(String linkNegotiation) {
        this.linkNegotiation = linkNegotiation;
        return this;
    }

    @ApiModelProperty(value="The Ethernet link negotiation that the terminal uses:  - `auto`: Auto-negotiation  - `100full`: 100 Mbps full duplex")
    @JsonProperty(value="linkNegotiation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLinkNegotiation() {
        return this.linkNegotiation;
    }

    @JsonProperty(value="linkNegotiation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkNegotiation(String linkNegotiation) {
        this.linkNegotiation = linkNegotiation;
    }

    public Terminal serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(value="The serial number of the terminal.")
    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Terminal simStatus(String simStatus) {
        this.simStatus = simStatus;
        return this;
    }

    @ApiModelProperty(value="On a terminal that supports 3G or 4G connectivity, indicates the status of the SIM card in the terminal: ACTIVE or INVENTORY.")
    @JsonProperty(value="simStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSimStatus() {
        return this.simStatus;
    }

    @JsonProperty(value="simStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSimStatus(String simStatus) {
        this.simStatus = simStatus;
    }

    public Terminal status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Indicates when the terminal was last online, whether the terminal is being reassigned, or whether the terminal is turned off. If the terminal was last online more that a week ago, it is also shown as turned off.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public Terminal storeStatus(String storeStatus) {
        this.storeStatus = storeStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the store that the terminal is assigned to.")
    @JsonProperty(value="storeStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreStatus() {
        return this.storeStatus;
    }

    @JsonProperty(value="storeStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreStatus(String storeStatus) {
        this.storeStatus = storeStatus;
    }

    public Terminal wifiIp(String wifiIp) {
        this.wifiIp = wifiIp;
        return this;
    }

    @ApiModelProperty(value="The terminal's IP address in your Wi-Fi network.")
    @JsonProperty(value="wifiIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWifiIp() {
        return this.wifiIp;
    }

    @JsonProperty(value="wifiIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWifiIp(String wifiIp) {
        this.wifiIp = wifiIp;
    }

    public Terminal wifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
        return this;
    }

    @ApiModelProperty(value="The terminal's MAC address in your Wi-Fi network.")
    @JsonProperty(value="wifiMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWifiMac() {
        return this.wifiMac;
    }

    @JsonProperty(value="wifiMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
    }

    public Terminal wifiSsid(String wifiSsid) {
        this.wifiSsid = wifiSsid;
        return this;
    }

    @ApiModelProperty(value="The SSID of the Wi-Fi network that your terminal is connected to.")
    @JsonProperty(value="wifiSsid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWifiSsid() {
        return this.wifiSsid;
    }

    @JsonProperty(value="wifiSsid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWifiSsid(String wifiSsid) {
        this.wifiSsid = wifiSsid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Terminal terminal = (Terminal)o;
        return Objects.equals(this.assigned, terminal.assigned) && Objects.equals(this.bluetoothIp, terminal.bluetoothIp) && Objects.equals(this.bluetoothMac, terminal.bluetoothMac) && Objects.equals(this.city, terminal.city) && Objects.equals(this.companyAccount, terminal.companyAccount) && Objects.equals(this.countryCode, terminal.countryCode) && Objects.equals(this.deviceModel, terminal.deviceModel) && Objects.equals(this.ethernetIp, terminal.ethernetIp) && Objects.equals(this.ethernetMac, terminal.ethernetMac) && Objects.equals(this.firmwareVersion, terminal.firmwareVersion) && Objects.equals(this.iccid, terminal.iccid) && Objects.equals(this.id, terminal.id) && Objects.equals(this.lastActivityDateTime, terminal.lastActivityDateTime) && Objects.equals(this.lastTransactionDateTime, terminal.lastTransactionDateTime) && Objects.equals(this.linkNegotiation, terminal.linkNegotiation) && Objects.equals(this.serialNumber, terminal.serialNumber) && Objects.equals(this.simStatus, terminal.simStatus) && Objects.equals(this.status, terminal.status) && Objects.equals(this.storeStatus, terminal.storeStatus) && Objects.equals(this.wifiIp, terminal.wifiIp) && Objects.equals(this.wifiMac, terminal.wifiMac) && Objects.equals(this.wifiSsid, terminal.wifiSsid);
    }

    public int hashCode() {
        return Objects.hash(this.assigned, this.bluetoothIp, this.bluetoothMac, this.city, this.companyAccount, this.countryCode, this.deviceModel, this.ethernetIp, this.ethernetMac, this.firmwareVersion, this.iccid, this.id, this.lastActivityDateTime, this.lastTransactionDateTime, this.linkNegotiation, this.serialNumber, this.simStatus, this.status, this.storeStatus, this.wifiIp, this.wifiMac, this.wifiSsid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Terminal {\n");
        sb.append("    assigned: ").append(this.toIndentedString(this.assigned)).append("\n");
        sb.append("    bluetoothIp: ").append(this.toIndentedString(this.bluetoothIp)).append("\n");
        sb.append("    bluetoothMac: ").append(this.toIndentedString(this.bluetoothMac)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    deviceModel: ").append(this.toIndentedString(this.deviceModel)).append("\n");
        sb.append("    ethernetIp: ").append(this.toIndentedString(this.ethernetIp)).append("\n");
        sb.append("    ethernetMac: ").append(this.toIndentedString(this.ethernetMac)).append("\n");
        sb.append("    firmwareVersion: ").append(this.toIndentedString(this.firmwareVersion)).append("\n");
        sb.append("    iccid: ").append(this.toIndentedString(this.iccid)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastActivityDateTime: ").append(this.toIndentedString(this.lastActivityDateTime)).append("\n");
        sb.append("    lastTransactionDateTime: ").append(this.toIndentedString(this.lastTransactionDateTime)).append("\n");
        sb.append("    linkNegotiation: ").append(this.toIndentedString(this.linkNegotiation)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    simStatus: ").append(this.toIndentedString(this.simStatus)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    storeStatus: ").append(this.toIndentedString(this.storeStatus)).append("\n");
        sb.append("    wifiIp: ").append(this.toIndentedString(this.wifiIp)).append("\n");
        sb.append("    wifiMac: ").append(this.toIndentedString(this.wifiMac)).append("\n");
        sb.append("    wifiSsid: ").append(this.toIndentedString(this.wifiSsid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Terminal fromJson(String jsonString) throws JsonProcessingException {
        return (Terminal)JSON.getMapper().readValue(jsonString, Terminal.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

