/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.Amount;
import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.SweepConfigurationSchedule;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"balanceAccountId", "id", "merchantAccount", "schedule", "status", "sweepAmount", "targetAmount", "transferInstrumentId", "triggerAmount", "type"})
public class SweepConfiguration {
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private SweepConfigurationSchedule schedule;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_SWEEP_AMOUNT = "sweepAmount";
    private Amount sweepAmount;
    public static final String JSON_PROPERTY_TARGET_AMOUNT = "targetAmount";
    private Amount targetAmount;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    private String transferInstrumentId;
    public static final String JSON_PROPERTY_TRIGGER_AMOUNT = "triggerAmount";
    private Amount triggerAmount;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.PUSH;

    public SweepConfiguration balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the destination or source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).   You can only use this for periodic sweep schedules such as `schedule.type` **daily** or **monthly**.")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public SweepConfiguration id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the sweep.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SweepConfiguration merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account that will be the source of funds. You can only use this if you are processing payments with Adyen. This can only be used for sweeps of `type` **pull** and `schedule.type` **balance**.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public SweepConfiguration schedule(SweepConfigurationSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SweepConfigurationSchedule getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchedule(SweepConfigurationSchedule schedule) {
        this.schedule = schedule;
    }

    public SweepConfiguration status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the sweep. If not provided, by default, this is set to **active**.  Possible values:    * **active**:  the sweep is enabled and funds will be pulled in or pushed out based on the defined configuration.    * **inactive**: the sweep is disabled and cannot be triggered.   ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SweepConfiguration sweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="sweepAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getSweepAmount() {
        return this.sweepAmount;
    }

    @JsonProperty(value="sweepAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
    }

    public SweepConfiguration targetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="targetAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getTargetAmount() {
        return this.targetAmount;
    }

    @JsonProperty(value="targetAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
    }

    public SweepConfiguration transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the destination or source [transfer instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/transferInstruments__resParam_id).  You can also use this in combination with a `merchantAccount` and a `type` **pull** to start a direct debit request from the source transfer instrument. To use this feature, reach out to your Adyen contact.")
    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public SweepConfiguration triggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="triggerAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getTriggerAmount() {
        return this.triggerAmount;
    }

    @JsonProperty(value="triggerAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTriggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
    }

    public SweepConfiguration type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The direction of sweep, whether pushing out or pulling in funds to the balance account. If not provided, by default, this is set to **push**.  Possible values:   * **push**: _push out funds_ to a destination balance account or transfer instrument.   * **pull**: _pull in funds_ from a source merchant account, transfer instrument, or balance account.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweepConfiguration sweepConfiguration = (SweepConfiguration)o;
        return Objects.equals(this.balanceAccountId, sweepConfiguration.balanceAccountId) && Objects.equals(this.id, sweepConfiguration.id) && Objects.equals(this.merchantAccount, sweepConfiguration.merchantAccount) && Objects.equals(this.schedule, sweepConfiguration.schedule) && Objects.equals((Object)this.status, (Object)sweepConfiguration.status) && Objects.equals(this.sweepAmount, sweepConfiguration.sweepAmount) && Objects.equals(this.targetAmount, sweepConfiguration.targetAmount) && Objects.equals(this.transferInstrumentId, sweepConfiguration.transferInstrumentId) && Objects.equals(this.triggerAmount, sweepConfiguration.triggerAmount) && Objects.equals((Object)this.type, (Object)sweepConfiguration.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceAccountId, this.id, this.merchantAccount, this.schedule, this.status, this.sweepAmount, this.targetAmount, this.transferInstrumentId, this.triggerAmount, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SweepConfiguration {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sweepAmount: ").append(this.toIndentedString(this.sweepAmount)).append("\n");
        sb.append("    targetAmount: ").append(this.toIndentedString(this.targetAmount)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("    triggerAmount: ").append(this.toIndentedString(this.triggerAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SweepConfiguration fromJson(String jsonString) throws JsonProcessingException {
        return (SweepConfiguration)JSON.getMapper().readValue(jsonString, SweepConfiguration.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PULL("pull"),
        PUSH("push");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

