/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"challengeWindowSize", "dataOnly", "nativeThreeDS", "threeDSVersion"})
public class ThreeDSRequestData {
    public static final String JSON_PROPERTY_CHALLENGE_WINDOW_SIZE = "challengeWindowSize";
    private ChallengeWindowSizeEnum challengeWindowSize;
    public static final String JSON_PROPERTY_DATA_ONLY = "dataOnly";
    private DataOnlyEnum dataOnly;
    public static final String JSON_PROPERTY_NATIVE_THREE_D_S = "nativeThreeDS";
    private NativeThreeDSEnum nativeThreeDS;
    public static final String JSON_PROPERTY_THREE_D_S_VERSION = "threeDSVersion";
    private ThreeDSVersionEnum threeDSVersion;

    public ThreeDSRequestData challengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
        this.challengeWindowSize = challengeWindowSize;
        return this;
    }

    @ApiModelProperty(value="Dimensions of the 3DS2 challenge window to be displayed to the cardholder.  Possible values:  * **01** - size of 250x400  * **02** - size of 390x400 * **03** - size of 500x600 * **04** - size of 600x400 * **05** - Fullscreen")
    @JsonProperty(value="challengeWindowSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChallengeWindowSizeEnum getChallengeWindowSize() {
        return this.challengeWindowSize;
    }

    @JsonProperty(value="challengeWindowSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChallengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
        this.challengeWindowSize = challengeWindowSize;
    }

    public ThreeDSRequestData dataOnly(DataOnlyEnum dataOnly) {
        this.dataOnly = dataOnly;
        return this;
    }

    @ApiModelProperty(value="Flag for data only flow.")
    @JsonProperty(value="dataOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DataOnlyEnum getDataOnly() {
        return this.dataOnly;
    }

    @JsonProperty(value="dataOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataOnly(DataOnlyEnum dataOnly) {
        this.dataOnly = dataOnly;
    }

    public ThreeDSRequestData nativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
        this.nativeThreeDS = nativeThreeDS;
        return this;
    }

    @ApiModelProperty(value="Indicates if [native 3D Secure authentication](https://docs.adyen.com/online-payments/3d-secure/native-3ds2) should be used when available.  Possible values: * **preferred**: Use native 3D Secure authentication when available.")
    @JsonProperty(value="nativeThreeDS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NativeThreeDSEnum getNativeThreeDS() {
        return this.nativeThreeDS;
    }

    @JsonProperty(value="nativeThreeDS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNativeThreeDS(NativeThreeDSEnum nativeThreeDS) {
        this.nativeThreeDS = nativeThreeDS;
    }

    public ThreeDSRequestData threeDSVersion(ThreeDSVersionEnum threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @ApiModelProperty(value="The version of 3D Secure to use.  Possible values:  * **2.1.0** * **2.2.0**")
    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSVersionEnum getThreeDSVersion() {
        return this.threeDSVersion;
    }

    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSVersion(ThreeDSVersionEnum threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSRequestData threeDSRequestData = (ThreeDSRequestData)o;
        return Objects.equals((Object)this.challengeWindowSize, (Object)threeDSRequestData.challengeWindowSize) && Objects.equals((Object)this.dataOnly, (Object)threeDSRequestData.dataOnly) && Objects.equals((Object)this.nativeThreeDS, (Object)threeDSRequestData.nativeThreeDS) && Objects.equals((Object)this.threeDSVersion, (Object)threeDSRequestData.threeDSVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.challengeWindowSize, this.dataOnly, this.nativeThreeDS, this.threeDSVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSRequestData {\n");
        sb.append("    challengeWindowSize: ").append(this.toIndentedString((Object)this.challengeWindowSize)).append("\n");
        sb.append("    dataOnly: ").append(this.toIndentedString((Object)this.dataOnly)).append("\n");
        sb.append("    nativeThreeDS: ").append(this.toIndentedString((Object)this.nativeThreeDS)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString((Object)this.threeDSVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ThreeDSRequestData fromJson(String jsonString) throws JsonProcessingException {
        return (ThreeDSRequestData)JSON.getMapper().readValue(jsonString, ThreeDSRequestData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ThreeDSVersionEnum {
        _1_0("V_2_1_0"),
        _2_0("V_2_2_0");

        private String value;

        private ThreeDSVersionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ThreeDSVersionEnum fromValue(String value) {
            for (ThreeDSVersionEnum b : ThreeDSVersionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum NativeThreeDSEnum {
        PREFERRED("preferred");

        private String value;

        private NativeThreeDSEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NativeThreeDSEnum fromValue(String value) {
            for (NativeThreeDSEnum b : NativeThreeDSEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DataOnlyEnum {
        FALSE("false"),
        TRUE("true");

        private String value;

        private DataOnlyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DataOnlyEnum fromValue(String value) {
            for (DataOnlyEnum b : DataOnlyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChallengeWindowSizeEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05");

        private String value;

        private ChallengeWindowSizeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChallengeWindowSizeEnum fromValue(String value) {
            for (ChallengeWindowSizeEnum b : ChallengeWindowSizeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

