/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.SweepConfigurationV2;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"hasNext", "hasPrevious", "sweeps"})
public class BalanceSweepConfigurationsResponse {
    public static final String JSON_PROPERTY_HAS_NEXT = "hasNext";
    private Boolean hasNext;
    public static final String JSON_PROPERTY_HAS_PREVIOUS = "hasPrevious";
    private Boolean hasPrevious;
    public static final String JSON_PROPERTY_SWEEPS = "sweeps";
    private List<SweepConfigurationV2> sweeps = new ArrayList<SweepConfigurationV2>();

    public BalanceSweepConfigurationsResponse hasNext(Boolean hasNext) {
        this.hasNext = hasNext;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the next page.")
    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasNext() {
        return this.hasNext;
    }

    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public BalanceSweepConfigurationsResponse hasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the previous page.")
    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPrevious() {
        return this.hasPrevious;
    }

    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    public BalanceSweepConfigurationsResponse sweeps(List<SweepConfigurationV2> sweeps) {
        this.sweeps = sweeps;
        return this;
    }

    public BalanceSweepConfigurationsResponse addSweepsItem(SweepConfigurationV2 sweepsItem) {
        this.sweeps.add(sweepsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of sweeps associated with the balance account.")
    @JsonProperty(value="sweeps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SweepConfigurationV2> getSweeps() {
        return this.sweeps;
    }

    @JsonProperty(value="sweeps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSweeps(List<SweepConfigurationV2> sweeps) {
        this.sweeps = sweeps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceSweepConfigurationsResponse balanceSweepConfigurationsResponse = (BalanceSweepConfigurationsResponse)o;
        return Objects.equals(this.hasNext, balanceSweepConfigurationsResponse.hasNext) && Objects.equals(this.hasPrevious, balanceSweepConfigurationsResponse.hasPrevious) && Objects.equals(this.sweeps, balanceSweepConfigurationsResponse.sweeps);
    }

    public int hashCode() {
        return Objects.hash(this.hasNext, this.hasPrevious, this.sweeps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceSweepConfigurationsResponse {\n");
        sb.append("    hasNext: ").append(this.toIndentedString(this.hasNext)).append("\n");
        sb.append("    hasPrevious: ").append(this.toIndentedString(this.hasPrevious)).append("\n");
        sb.append("    sweeps: ").append(this.toIndentedString(this.sweeps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceSweepConfigurationsResponse fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceSweepConfigurationsResponse)JSON.getMapper().readValue(jsonString, BalanceSweepConfigurationsResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

