/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.Company;
import com.adyen.model.management.ListCompanyResponse;
import com.adyen.model.management.ListMerchantResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AccountCompanyLevelApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public AccountCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v1");
    }

    public AccountCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public ListCompanyResponse listCompanyAccounts() throws ApiException, IOException {
        return this.listCompanyAccounts(null, null, null);
    }

    public ListCompanyResponse listCompanyAccounts(Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListCompanyResponse.fromJson(jsonResult);
    }

    public Company getCompanyAccount(String companyId) throws ApiException, IOException {
        return this.getCompanyAccount(companyId, null);
    }

    public Company getCompanyAccount(String companyId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Company.fromJson(jsonResult);
    }

    public ListMerchantResponse listMerchantAccounts(String companyId) throws ApiException, IOException {
        return this.listMerchantAccounts(companyId, null, null, null);
    }

    public ListMerchantResponse listMerchantAccounts(String companyId, Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/merchants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListMerchantResponse.fromJson(jsonResult);
    }
}

