/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.legalentitymanagement.GeneratePciDescriptionRequest;
import com.adyen.model.legalentitymanagement.GeneratePciDescriptionResponse;
import com.adyen.model.legalentitymanagement.GetPciQuestionnaireInfosResponse;
import com.adyen.model.legalentitymanagement.GetPciQuestionnaireResponse;
import com.adyen.model.legalentitymanagement.PciSigningRequest;
import com.adyen.model.legalentitymanagement.PciSigningResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PciQuestionnairesApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public PciQuestionnairesApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    public PciQuestionnairesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public GetPciQuestionnaireInfosResponse getPciQuestionnaireDetails(String id) throws ApiException, IOException {
        return this.getPciQuestionnaireDetails(id, null);
    }

    public GetPciQuestionnaireInfosResponse getPciQuestionnaireDetails(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return GetPciQuestionnaireInfosResponse.fromJson(jsonResult);
    }

    public GetPciQuestionnaireResponse getPciQuestionnaire(String id, String pciid) throws ApiException, IOException {
        return this.getPciQuestionnaire(id, pciid, null);
    }

    public GetPciQuestionnaireResponse getPciQuestionnaire(String id, String pciid, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        if (pciid == null) {
            throw new IllegalArgumentException("Please provide the pciid path parameter");
        }
        pathParams.put("pciid", pciid);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires/{pciid}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return GetPciQuestionnaireResponse.fromJson(jsonResult);
    }

    public GeneratePciDescriptionResponse generatePciQuestionnaire(String id, GeneratePciDescriptionRequest generatePciDescriptionRequest) throws ApiException, IOException {
        return this.generatePciQuestionnaire(id, generatePciDescriptionRequest, null);
    }

    public GeneratePciDescriptionResponse generatePciQuestionnaire(String id, GeneratePciDescriptionRequest generatePciDescriptionRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = generatePciDescriptionRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires/generatePciTemplates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return GeneratePciDescriptionResponse.fromJson(jsonResult);
    }

    public PciSigningResponse signPciQuestionnaire(String id, PciSigningRequest pciSigningRequest) throws ApiException, IOException {
        return this.signPciQuestionnaire(id, pciSigningRequest, null);
    }

    public PciSigningResponse signPciQuestionnaire(String id, PciSigningRequest pciSigningRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = pciSigningRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires/signPciTemplates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PciSigningResponse.fromJson(jsonResult);
    }
}

