/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.TransactionEventViolation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"advice", "allRulesPassed", "failedTransactionRules", "score"})
public class TransactionRulesResult {
    public static final String JSON_PROPERTY_ADVICE = "advice";
    private String advice;
    public static final String JSON_PROPERTY_ALL_RULES_PASSED = "allRulesPassed";
    private Boolean allRulesPassed;
    public static final String JSON_PROPERTY_FAILED_TRANSACTION_RULES = "failedTransactionRules";
    private List<TransactionEventViolation> failedTransactionRules = null;
    public static final String JSON_PROPERTY_SCORE = "score";
    private Integer score;

    public TransactionRulesResult advice(String advice) {
        this.advice = advice;
        return this;
    }

    @ApiModelProperty(value="The advice given by the Risk analysis.")
    @JsonProperty(value="advice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAdvice() {
        return this.advice;
    }

    @JsonProperty(value="advice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdvice(String advice) {
        this.advice = advice;
    }

    public TransactionRulesResult allRulesPassed(Boolean allRulesPassed) {
        this.allRulesPassed = allRulesPassed;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the transaction passed the evaluation for all transaction rules.")
    @JsonProperty(value="allRulesPassed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllRulesPassed() {
        return this.allRulesPassed;
    }

    @JsonProperty(value="allRulesPassed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllRulesPassed(Boolean allRulesPassed) {
        this.allRulesPassed = allRulesPassed;
    }

    public TransactionRulesResult failedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
        this.failedTransactionRules = failedTransactionRules;
        return this;
    }

    public TransactionRulesResult addFailedTransactionRulesItem(TransactionEventViolation failedTransactionRulesItem) {
        if (this.failedTransactionRules == null) {
            this.failedTransactionRules = new ArrayList<TransactionEventViolation>();
        }
        this.failedTransactionRules.add(failedTransactionRulesItem);
        return this;
    }

    @ApiModelProperty(value="Array containing all the transaction rules that the transaction violated. This list is only sent when `allRulesPassed` is **false**.")
    @JsonProperty(value="failedTransactionRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransactionEventViolation> getFailedTransactionRules() {
        return this.failedTransactionRules;
    }

    @JsonProperty(value="failedTransactionRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
        this.failedTransactionRules = failedTransactionRules;
    }

    public TransactionRulesResult score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(value="The score of the Risk analysis.")
    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getScore() {
        return this.score;
    }

    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScore(Integer score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRulesResult transactionRulesResult = (TransactionRulesResult)o;
        return Objects.equals(this.advice, transactionRulesResult.advice) && Objects.equals(this.allRulesPassed, transactionRulesResult.allRulesPassed) && Objects.equals(this.failedTransactionRules, transactionRulesResult.failedTransactionRules) && Objects.equals(this.score, transactionRulesResult.score);
    }

    public int hashCode() {
        return Objects.hash(this.advice, this.allRulesPassed, this.failedTransactionRules, this.score);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRulesResult {\n");
        sb.append("    advice: ").append(this.toIndentedString(this.advice)).append("\n");
        sb.append("    allRulesPassed: ").append(this.toIndentedString(this.allRulesPassed)).append("\n");
        sb.append("    failedTransactionRules: ").append(this.toIndentedString(this.failedTransactionRules)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransactionRulesResult fromJson(String jsonString) throws JsonProcessingException {
        return (TransactionRulesResult)JSON.getMapper().readValue(jsonString, TransactionRulesResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

