/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acceptedBy", "ipAddress"})
public class AcceptTermsOfServiceRequest {
    public static final String JSON_PROPERTY_ACCEPTED_BY = "acceptedBy";
    private String acceptedBy;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;

    public AcceptTermsOfServiceRequest acceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
        return this;
    }

    @ApiModelProperty(required=true, value="The individual legal entity ID of the user accepting the Terms of Service. This can also be the legal entity ID of the signatory for an organization.")
    @JsonProperty(value="acceptedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcceptedBy() {
        return this.acceptedBy;
    }

    @JsonProperty(value="acceptedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
    }

    public AcceptTermsOfServiceRequest ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(value="The IP address of the user accepting the Terms of Service.")
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptTermsOfServiceRequest acceptTermsOfServiceRequest = (AcceptTermsOfServiceRequest)o;
        return Objects.equals(this.acceptedBy, acceptTermsOfServiceRequest.acceptedBy) && Objects.equals(this.ipAddress, acceptTermsOfServiceRequest.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.acceptedBy, this.ipAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceptTermsOfServiceRequest {\n");
        sb.append("    acceptedBy: ").append(this.toIndentedString(this.acceptedBy)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AcceptTermsOfServiceRequest fromJson(String jsonString) throws JsonProcessingException {
        return (AcceptTermsOfServiceRequest)JSON.getMapper().readValue(jsonString, AcceptTermsOfServiceRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

