/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"billingSequenceNumber", "checkoutAttemptId", "recurringDetailReference", "shopperNotificationReference", "storedPaymentMethodId", "type", "virtualPaymentAddress"})
public class UpiCollectDetails {
    public static final String JSON_PROPERTY_BILLING_SEQUENCE_NUMBER = "billingSequenceNumber";
    private String billingSequenceNumber;
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_NOTIFICATION_REFERENCE = "shopperNotificationReference";
    private String shopperNotificationReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.UPI_COLLECT;
    public static final String JSON_PROPERTY_VIRTUAL_PAYMENT_ADDRESS = "virtualPaymentAddress";
    private String virtualPaymentAddress;

    public UpiCollectDetails billingSequenceNumber(String billingSequenceNumber) {
        this.billingSequenceNumber = billingSequenceNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The sequence number for the debit. For example, send **2** if this is the second debit for the subscription. The sequence number is included in the notification sent to the shopper.")
    @JsonProperty(value="billingSequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBillingSequenceNumber() {
        return this.billingSequenceNumber;
    }

    @JsonProperty(value="billingSequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingSequenceNumber(String billingSequenceNumber) {
        this.billingSequenceNumber = billingSequenceNumber;
    }

    public UpiCollectDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public UpiCollectDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @Deprecated
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public UpiCollectDetails shopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
        return this;
    }

    @ApiModelProperty(value="The `shopperNotificationReference` returned in the response when you requested to notify the shopper. Used for recurring payment only.")
    @JsonProperty(value="shopperNotificationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperNotificationReference() {
        return this.shopperNotificationReference;
    }

    @JsonProperty(value="shopperNotificationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
    }

    public UpiCollectDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public UpiCollectDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**upi_collect**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UpiCollectDetails virtualPaymentAddress(String virtualPaymentAddress) {
        this.virtualPaymentAddress = virtualPaymentAddress;
        return this;
    }

    @ApiModelProperty(value="The virtual payment address for UPI.")
    @JsonProperty(value="virtualPaymentAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVirtualPaymentAddress() {
        return this.virtualPaymentAddress;
    }

    @JsonProperty(value="virtualPaymentAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVirtualPaymentAddress(String virtualPaymentAddress) {
        this.virtualPaymentAddress = virtualPaymentAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpiCollectDetails upiCollectDetails = (UpiCollectDetails)o;
        return Objects.equals(this.billingSequenceNumber, upiCollectDetails.billingSequenceNumber) && Objects.equals(this.checkoutAttemptId, upiCollectDetails.checkoutAttemptId) && Objects.equals(this.recurringDetailReference, upiCollectDetails.recurringDetailReference) && Objects.equals(this.shopperNotificationReference, upiCollectDetails.shopperNotificationReference) && Objects.equals(this.storedPaymentMethodId, upiCollectDetails.storedPaymentMethodId) && Objects.equals((Object)this.type, (Object)upiCollectDetails.type) && Objects.equals(this.virtualPaymentAddress, upiCollectDetails.virtualPaymentAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.billingSequenceNumber, this.checkoutAttemptId, this.recurringDetailReference, this.shopperNotificationReference, this.storedPaymentMethodId, this.type, this.virtualPaymentAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpiCollectDetails {\n");
        sb.append("    billingSequenceNumber: ").append(this.toIndentedString(this.billingSequenceNumber)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperNotificationReference: ").append(this.toIndentedString(this.shopperNotificationReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    virtualPaymentAddress: ").append(this.toIndentedString(this.virtualPaymentAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpiCollectDetails fromJson(String jsonString) throws JsonProcessingException {
        return (UpiCollectDetails)JSON.getMapper().readValue(jsonString, UpiCollectDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        UPI_COLLECT("upi_collect");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

